/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.wasbuilder;

import com.michelin.cio.hudson.plugins.wasbuilder.WASInstallation;
import hudson.EnvVars;
import hudson.Launcher;
import hudson.Util;
import hudson.model.EnvironmentSpecific;
import hudson.model.Hudson;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class WASInstallation
extends ToolInstallation
implements NodeSpecific<WASInstallation>,
EnvironmentSpecific<WASInstallation> {
    public static final String WSADMIN_BAT = "wsadmin.bat";
    public static final String WSADMIN_SH = "wsadmin.sh";
    private final String wsadminCommand;
    private static final Logger LOGGER = Logger.getLogger(WASInstallation.class.getName());

    @DataBoundConstructor
    public WASInstallation(String name, String home, String wsadminCommand) {
        super(name, WASInstallation.removeTrailingBackslash((String)home), Collections.EMPTY_LIST);
        this.wsadminCommand = StringUtils.isBlank((String)wsadminCommand) ? "${WSADMIN}" : wsadminCommand;
    }

    public WASInstallation forEnvironment(EnvVars env) {
        return new WASInstallation(this.getName(), env.expand(this.getHome()), this.getWsadminCommand());
    }

    public WASInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new WASInstallation(this.getName(), this.translateFor(node, log), this.getWsadminCommand());
    }

    public static WASInstallation getWasInstallationByName(String installationName) {
        for (WASInstallation installation : (WASInstallation[])((DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class)).getInstallations()) {
            if (installationName == null || !installation.getName().equals(installationName)) continue;
            return installation;
        }
        return null;
    }

    public String getWsadminCommand() {
        if (StringUtils.isBlank((String)this.wsadminCommand)) {
            return "${WSADMIN}";
        }
        return this.wsadminCommand;
    }

    public String getWsadminExecutable(Launcher launcher) throws IOException, InterruptedException {
        return (String)launcher.getChannel().call((Callable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private File getWsadminFile(String binFolder) {
        String wsadminFileName = "wsadmin.sh";
        binFolder = !StringUtils.isEmpty((String)binFolder) ? binFolder + "/" : "";
        if (Hudson.isWindows()) {
            wsadminFileName = "wsadmin.bat";
        }
        return new File(Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars), binFolder + wsadminFileName);
    }

    private static String removeTrailingBackslash(String s) {
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)s, (String)"/"), (String)"\\");
    }

    static /* synthetic */ File access$000(WASInstallation x0, String x1) {
        return x0.getWsadminFile(x1);
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

