/*
 * Decompiled with CFR 0.152.
 */
package com.michelin.cio.hudson.plugins.wasbuilder;

import com.michelin.cio.hudson.plugins.wasbuilder.WASInstallation;
import hudson.util.Secret;
import java.util.Arrays;
import org.kohsuke.stapler.DataBoundConstructor;

public class WASServer {
    public static final String CONNTYPE_JSR160RMI = "JSR160RMI";
    public static final String CONNTYPE_RMI = "RMI";
    public static final String CONNTYPE_SOAP = "SOAP";
    public static final String[] CONNTYPES = new String[]{"SOAP", "RMI", "JSR160RMI"};
    private final String wasInstallationName;
    private final String name;
    private final String conntype;
    private final String host;
    private final int port;
    private final String user;
    private Secret password;

    @DataBoundConstructor
    public WASServer(String wasInstallationName, String name, String conntype, String host, int port, String user, String password) {
        this.wasInstallationName = wasInstallationName;
        this.name = name;
        this.conntype = conntype == null || !Arrays.asList(CONNTYPES).contains(conntype) ? CONNTYPE_SOAP : conntype;
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = Secret.fromString((String)password);
    }

    public String getConntype() {
        return this.conntype;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password.toString();
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public WASInstallation getWasInstallation() {
        return WASInstallation.getWasInstallationByName(this.getWasInstallationName());
    }

    public String getWasInstallationName() {
        return this.wasInstallationName;
    }
}

