/*
 * Decompiled with CFR 0.152.
 */
package webtestpresenter;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import webtestpresenter.WebtestPublisher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class WebtestPublisher
extends Notifier
implements Serializable {
    private static final String WEBTEST_REPORTS = "webtestReports";
    private static final long serialVersionUID = 1L;
    private final String webtestResultsSrcDir;

    WebtestPublisher(String webtestResultsSrcDir) {
        this.webtestResultsSrcDir = webtestResultsSrcDir;
    }

    public String getWebtestResultsSrcDir() {
        return this.webtestResultsSrcDir;
    }

    private static FilePath getWebtestReportDir(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), "webtestReports"));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        long buildTime = build.getTimestamp().getTimeInMillis();
        FilePath webtestResults = build.getWorkspace().child(this.webtestResultsSrcDir);
        FilePath target = WebtestPublisher.getWebtestReportDir(build);
        WebtestReportAction action = null;
        try {
            if (!webtestResults.exists()) {
                return true;
            }
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && buildTime + 1000L > webtestResults.lastModified()) {
                listener.getLogger().println("Webtest reports are stale.  Not publishing.");
                return true;
            }
            StringBuffer msgBuf = new StringBuffer("Publishing webtest results: ");
            msgBuf.append(this.webtestResultsSrcDir);
            msgBuf.append(" to: ");
            msgBuf.append(target);
            listener.getLogger().println(msgBuf.toString());
            webtestResults.copyRecursiveTo("**/*", target);
            action = new WebtestReportAction(build);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String err = "Unable to copy Webtest results from " + webtestResults + " to " + target;
            e.printStackTrace(listener.fatalError(err));
            build.setResult(Result.FAILURE);
        }
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(AbstractBuild<?, ?> build) {
        return new WebtestReportAction(build);
    }

    static /* synthetic */ FilePath access$000(AbstractBuild x0) {
        return WebtestPublisher.getWebtestReportDir((AbstractBuild)x0);
    }
}

