/*
 * Decompiled with CFR 0.152.
 */
package webtestpresenter;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebtestPublisher
extends Notifier
implements Serializable {
    private static final String WEBTEST_REPORTS = "webtestReports";
    private static final long serialVersionUID = 1L;
    private final String webtestResultsSrcDir;

    WebtestPublisher(String webtestResultsSrcDir) {
        this.webtestResultsSrcDir = webtestResultsSrcDir;
    }

    public String getWebtestResultsSrcDir() {
        return this.webtestResultsSrcDir;
    }

    private static FilePath getWebtestReportDir(AbstractBuild<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), WEBTEST_REPORTS));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException {
        long buildTime = build.getTimestamp().getTimeInMillis();
        FilePath webtestResults = build.getWorkspace().child(this.webtestResultsSrcDir);
        FilePath target = WebtestPublisher.getWebtestReportDir(build);
        WebtestReportAction action = null;
        try {
            if (!webtestResults.exists()) {
                return true;
            }
            if (build.getResult().isWorseOrEqualTo(Result.FAILURE) && buildTime + 1000L > webtestResults.lastModified()) {
                listener.getLogger().println("Webtest reports are stale.  Not publishing.");
                return true;
            }
            StringBuffer msgBuf = new StringBuffer("Publishing webtest results: ");
            msgBuf.append(this.webtestResultsSrcDir);
            msgBuf.append(" to: ");
            msgBuf.append(target);
            listener.getLogger().println(msgBuf.toString());
            webtestResults.copyRecursiveTo("**/*", target);
            action = new WebtestReportAction(build);
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String err = "Unable to copy Webtest results from " + webtestResults + " to " + target;
            e.printStackTrace(listener.fatalError(err));
            build.setResult(Result.FAILURE);
        }
        build.getActions().add(action);
        return true;
    }

    public Action getProjectAction(AbstractBuild<?, ?> build) {
        return new WebtestReportAction(build);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WebtestReportAction
    implements Action {
        private static final long serialVersionUID = -3578312514160132918L;
        public final AbstractBuild<?, ?> build;

        public WebtestReportAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        public String getUrlName() {
            return "webtestResults";
        }

        public String getDisplayName() {
            return "Webtest Results";
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public Object getTarget() {
            if (this.build != null) {
                return WebtestPublisher.getWebtestReportDir(this.build);
            }
            return null;
        }

        public DirectoryBrowserSupport doDynamic(StaplerRequest req, StaplerResponse rsp) {
            if (this.build != null) {
                return new DirectoryBrowserSupport((ModelObject)this, WebtestPublisher.getWebtestReportDir(this.build), "webtest", "clipboard.gif", false);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final String CONFIG_PARAM = "webtest_publisher.webtestResultsSrc";
        private String webtestResultsSrc;

        public DescriptorImpl() {
            super(WebtestPublisher.class);
        }

        public String getDisplayName() {
            return "Publish Webtest results";
        }

        public String getWebtestResultsSrc() {
            return this.webtestResultsSrc;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.webtestResultsSrc = req.getParameter(CONFIG_PARAM);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return FilePath.validateFileMask((FilePath)project.getSomeWorkspace(), (String)value);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public WebtestPublisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new WebtestPublisher(req.getParameter(CONFIG_PARAM));
        }
    }
}

