/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.scripting.wrapper;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hudsonci.plugins.scripting.wrapper.ScriptBuildWrapper;
import org.hudsonci.utils.common.Varargs;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@XStreamAlias(value="script-build-wrapper")
public class ScriptBuildWrapper
extends BuildWrapper {
    private static final Logger log = LoggerFactory.getLogger(ScriptBuildWrapper.class);
    private final String source;
    private final Mode mode;
    @XStreamOmitField
    private Class<? extends Script> compiledScriptType;

    @DataBoundConstructor
    public ScriptBuildWrapper(String source, String mode) {
        this.source = (String)Preconditions.checkNotNull((Object)source);
        this.mode = Mode.valueOf((String)((String)Preconditions.checkNotNull((Object)mode)));
        this.compile();
    }

    @JellyAccessible
    public String getSource() {
        return this.source;
    }

    @JellyAccessible
    public Mode getMode() {
        return this.mode;
    }

    private Object readResolve() {
        this.compile();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.compiledScriptType != null) {
                InvokerHelper.removeClass((Class)this.compiledScriptType);
            }
        }
        finally {
            super.finalize();
        }
    }

    private void compile() {
        if (this.compiledScriptType != null) {
            InvokerHelper.removeClass((Class)this.compiledScriptType);
        }
        this.compiledScriptType = this.compile(this.source);
    }

    private Class<? extends Script> compile(String source) {
        assert (source != null);
        CompilerConfiguration cc = new CompilerConfiguration();
        Binding binding = new Binding();
        ClassLoader cl = Hudson.getInstance().pluginManager.uberClassLoader;
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        String scriptName = String.format("%s_%d.groovy", this.getClass().getSimpleName(), System.identityHashCode(this));
        log.trace("Compiling script {}:\n{}", (Object)scriptName, (Object)source);
        Script script = shell.parse(source, scriptName);
        Class<?> type = script.getClass();
        log.trace("Compiled script class: {}", type);
        return type;
    }

    private boolean matches(Mode mode) {
        return this.mode == mode || this.mode == Mode.ALL;
    }

    private <T> T execute(Mode mode, Map<String, Object> vars, Class<T> resultType) {
        Class<?> type;
        Object result;
        log.debug("Executing script in mode: {}", (Object)mode);
        try {
            Script script = (Script)this.compiledScriptType.newInstance();
            Binding binding = new Binding(vars);
            binding.setVariable("mode", (Object)mode);
            binding.setVariable("container", (Object)this);
            if (log.isDebugEnabled()) {
                log.debug("Binding variables:");
                for (Object key : binding.getVariables().keySet()) {
                    Object value = binding.getVariables().get(key);
                    Class<?> type2 = value != null ? value.getClass() : null;
                    log.debug("  {}={} ({})", Varargs.$((Object[])new Object[]{key, value, type2}));
                }
            }
            script.setBinding(binding);
            result = script.run();
            log.debug("Script result: {}", result);
        }
        catch (Exception e) {
            log.error("Script execution failed", (Throwable)e);
            throw new RuntimeException("Script execution failed", e);
        }
        if (result != null && !resultType.isAssignableFrom(type = result.getClass())) {
            log.warn("Incompatible result type; expect: {}, have: {}", resultType, type);
        }
        return (T)result;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        log.trace("setUp");
        if (this.matches(Mode.SETUP)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("launcher", launcher);
            vars.put("listener", listener);
            BuildWrapper.Environment result = (BuildWrapper.Environment)this.execute(Mode.SETUP, vars, BuildWrapper.Environment.class);
            if (result != null) {
                return result;
            }
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        log.trace("decorateLauncher");
        if (this.matches(Mode.DECORATE_LAUNCHER)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("launcher", launcher);
            vars.put("listener", listener);
            Launcher result = (Launcher)this.execute(Mode.DECORATE_LAUNCHER, vars, Launcher.class);
            if (result != null) {
                return result;
            }
        }
        return launcher;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        log.trace("decorateLogger");
        if (this.matches(Mode.DECORATE_LOGGER)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("logger", logger);
            OutputStream result = (OutputStream)this.execute(Mode.DECORATE_LOGGER, vars, OutputStream.class);
            if (result != null) {
                return result;
            }
        }
        return logger;
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        log.trace("makeBuildVariables");
        if (this.matches(Mode.BUILD_VARIABLES)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("vars", variables);
            this.execute(Mode.BUILD_VARIABLES, vars, null);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    static /* synthetic */ boolean access$100(ScriptBuildWrapper x0, Mode x1) {
        return x0.matches(x1);
    }

    static /* synthetic */ Object access$200(ScriptBuildWrapper x0, Mode x1, Map x2, Class x3) {
        return x0.execute(x1, x2, x3);
    }
}

