/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.scripting.wrapper;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Typed;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.hudsonci.utils.common.Varargs;
import org.hudsonci.utils.plugin.ui.JellyAccessible;
import org.hudsonci.utils.plugin.ui.RenderableEnum;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XStreamAlias(value="script-build-wrapper")
public class ScriptBuildWrapper
extends BuildWrapper {
    private static final Logger log = LoggerFactory.getLogger(ScriptBuildWrapper.class);
    private final String source;
    private final Mode mode;
    @XStreamOmitField
    private Class<? extends Script> compiledScriptType;

    @DataBoundConstructor
    public ScriptBuildWrapper(String source, String mode) {
        this.source = (String)Preconditions.checkNotNull((Object)source);
        this.mode = Mode.valueOf((String)Preconditions.checkNotNull((Object)mode));
        this.compile();
    }

    @JellyAccessible
    public String getSource() {
        return this.source;
    }

    @JellyAccessible
    public Mode getMode() {
        return this.mode;
    }

    private Object readResolve() {
        this.compile();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.compiledScriptType != null) {
                InvokerHelper.removeClass(this.compiledScriptType);
            }
        }
        finally {
            super.finalize();
        }
    }

    private void compile() {
        if (this.compiledScriptType != null) {
            InvokerHelper.removeClass(this.compiledScriptType);
        }
        this.compiledScriptType = this.compile(this.source);
    }

    private Class<? extends Script> compile(String source) {
        assert (source != null);
        CompilerConfiguration cc = new CompilerConfiguration();
        Binding binding = new Binding();
        ClassLoader cl = Hudson.getInstance().pluginManager.uberClassLoader;
        GroovyShell shell = new GroovyShell(cl, binding, cc);
        String scriptName = String.format("%s_%d.groovy", ((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this));
        log.trace("Compiling script {}:\n{}", (Object)scriptName, (Object)source);
        Script script = shell.parse(source, scriptName);
        Class<?> type = script.getClass();
        log.trace("Compiled script class: {}", type);
        return type;
    }

    private boolean matches(Mode mode) {
        return this.mode == mode || this.mode == Mode.ALL;
    }

    private <T> T execute(Mode mode, Map<String, Object> vars, Class<T> resultType) {
        Class<?> type;
        Object result;
        log.debug("Executing script in mode: {}", (Object)mode);
        try {
            Script script = this.compiledScriptType.newInstance();
            Binding binding = new Binding(vars);
            binding.setVariable("mode", (Object)mode);
            binding.setVariable("container", (Object)this);
            if (log.isDebugEnabled()) {
                log.debug("Binding variables:");
                for (Object key : binding.getVariables().keySet()) {
                    Object value = binding.getVariables().get(key);
                    Class<?> type2 = value != null ? value.getClass() : null;
                    log.debug("  {}={} ({})", Varargs.$((Object[])new Object[]{key, value, type2}));
                }
            }
            script.setBinding(binding);
            result = script.run();
            log.debug("Script result: {}", result);
        }
        catch (Exception e) {
            log.error("Script execution failed", (Throwable)e);
            throw new RuntimeException("Script execution failed", e);
        }
        if (result != null && !resultType.isAssignableFrom(type = result.getClass())) {
            log.warn("Incompatible result type; expect: {}, have: {}", resultType, type);
        }
        return (T)result;
    }

    public BuildWrapper.Environment setUp(final AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        log.trace("setUp");
        if (this.matches(Mode.SETUP)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("launcher", launcher);
            vars.put("listener", listener);
            BuildWrapper.Environment result = this.execute(Mode.SETUP, vars, BuildWrapper.Environment.class);
            if (result != null) {
                return result;
            }
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build2, BuildListener listener) throws IOException, InterruptedException {
                log.trace("tearDown");
                if (ScriptBuildWrapper.this.matches(Mode.TEAR_DOWN)) {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("build", build2);
                    vars.put("launcher", launcher);
                    Boolean result = (Boolean)ScriptBuildWrapper.this.execute(Mode.TEAR_DOWN, vars, Boolean.class);
                    if (result != null) {
                        return result;
                    }
                }
                return true;
            }

            public void buildEnvVars(Map<String, String> env) {
                log.trace("buildEnvVars");
                if (ScriptBuildWrapper.this.matches(Mode.ENVIRONMENT_VARIABLES)) {
                    HashMap<String, Object> vars = new HashMap<String, Object>();
                    vars.put("build", build);
                    vars.put("vars", env);
                    ScriptBuildWrapper.this.execute(Mode.ENVIRONMENT_VARIABLES, vars, null);
                }
            }
        };
    }

    public Launcher decorateLauncher(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
        log.trace("decorateLauncher");
        if (this.matches(Mode.DECORATE_LAUNCHER)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("launcher", launcher);
            vars.put("listener", listener);
            Launcher result = this.execute(Mode.DECORATE_LAUNCHER, vars, Launcher.class);
            if (result != null) {
                return result;
            }
        }
        return launcher;
    }

    public OutputStream decorateLogger(AbstractBuild build, OutputStream logger) throws IOException, InterruptedException, Run.RunnerAbortedException {
        log.trace("decorateLogger");
        if (this.matches(Mode.DECORATE_LOGGER)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("logger", logger);
            OutputStream result = this.execute(Mode.DECORATE_LOGGER, vars, OutputStream.class);
            if (result != null) {
                return result;
            }
        }
        return logger;
    }

    public void makeBuildVariables(AbstractBuild build, Map<String, String> variables) {
        log.trace("makeBuildVariables");
        if (this.matches(Mode.BUILD_VARIABLES)) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("build", build);
            vars.put("vars", variables);
            this.execute(Mode.BUILD_VARIABLES, vars, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SETUP,
        TEAR_DOWN,
        DECORATE_LAUNCHER,
        DECORATE_LOGGER,
        BUILD_VARIABLES,
        ENVIRONMENT_VARIABLES,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Named
    @Singleton
    @Typed(value={Descriptor.class})
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @JellyAccessible
        public RenderableEnum[] getModeValues() {
            return RenderableEnum.forEnum(Mode.class);
        }

        @JellyAccessible
        public Mode getDefaultMode() {
            return Mode.SETUP;
        }

        @JellyAccessible
        public boolean isSelected(Object value, Object configValue, Object defaultValue) {
            assert (value != null);
            return value.equals(configValue) || configValue == null && value.equals(defaultValue);
        }

        public String getDisplayName() {
            return "Script Build Wrapper";
        }
    }
}

