/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import maps.hudson.plugin.xfpanel.XFPanelView;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private XFColors colors;
    private Integer numColumns = 1;
    private Integer refresh = 3;
    private Boolean fullHD = false;
    private Boolean showDescription = false;
    private Boolean showBrokenBuildCount = false;
    private Boolean showZeroTestCounts = true;
    private Boolean sortDescending = false;
    private Boolean failedBuildsBelow = false;
    private Boolean greenColors = false;
    private transient List<XFPanelEntry> entries;
    private transient Map<Queue.Item, Integer> placeInQueue = new HashMap();

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 1;
    }

    public XFColors getColors() {
        if (this.getgreenColors().booleanValue()) {
            this.colors = XFColors.GREEN;
            return this.colors;
        }
        this.colors = XFColors.DEFAULT;
        return this.colors;
    }

    public Boolean getFullHD() {
        return this.fullHD;
    }

    public Boolean getShowDescription() {
        if (this.showDescription == null) {
            this.showDescription = false;
        }
        return this.showDescription;
    }

    public Boolean getShowBrokenBuildCount() {
        if (this.showBrokenBuildCount == null) {
            this.showBrokenBuildCount = false;
        }
        return this.showBrokenBuildCount;
    }

    public Boolean getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = false;
        }
        return this.sortDescending;
    }

    public Boolean getfailedBuildsBelow() {
        if (this.failedBuildsBelow == null) {
            this.failedBuildsBelow = false;
        }
        return this.failedBuildsBelow;
    }

    public Boolean getgreenColors() {
        if (this.greenColors == null) {
            this.greenColors = false;
        }
        return this.greenColors;
    }

    public Boolean getShowZeroTestCounts() {
        if (this.showZeroTestCounts == null) {
            this.showZeroTestCounts = true;
        }
        return this.showZeroTestCounts;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                ents.add(new XFPanelEntry(this, job));
            }
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Collection<XFPanelEntry> sortFailedBuildsBelow(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList ents = new ArrayList();
            ArrayList<XFPanelEntry> entsS = new ArrayList<XFPanelEntry>();
            ArrayList<XFPanelEntry> entsF = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                String result = job.getLastCompletedBuild().getResult().toString();
                if (result == "SUCCESS") {
                    entsS.add(new XFPanelEntry(this, job));
                    continue;
                }
                entsF.add(new XFPanelEntry(this, job));
            }
            ents.addAll(entsS);
            ents.addAll(entsF);
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        try {
            this.numColumns = Integer.parseInt(req.getParameter("numColumns"));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException("Number of columns currently supported is 1 or 2.", "numColumns");
        }
        try {
            this.refresh = Integer.parseInt(req.getParameter("refresh"));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException("Refresh time must be a positive integer.", "refresh");
        }
        this.fullHD = Boolean.parseBoolean(req.getParameter("fullHD"));
        this.showDescription = Boolean.parseBoolean(req.getParameter("showDescription"));
        this.showBrokenBuildCount = Boolean.parseBoolean(req.getParameter("showBrokenBuildCount"));
        this.sortDescending = Boolean.parseBoolean(req.getParameter("sortDescending"));
        this.failedBuildsBelow = Boolean.parseBoolean(req.getParameter("failedBuildsBelow"));
        this.greenColors = Boolean.parseBoolean(req.getParameter("greenColors"));
        this.showZeroTestCounts = Boolean.parseBoolean(req.getParameter("showZeroTestCounts"));
    }

    static /* synthetic */ Map access$000(XFPanelView x0) {
        return x0.placeInQueue;
    }

    static /* synthetic */ XFColors access$100(XFPanelView x0) {
        return x0.colors;
    }
}

