/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewDescriptor;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private XFColors colors;
    private Integer numColumns = 1;
    private Integer refresh = 3;
    private Boolean fullHD = false;
    private Boolean showDescription = false;
    private Boolean showBrokenBuildCount = false;
    private Boolean showZeroTestCounts = true;
    private Boolean sortDescending = false;
    private Boolean failedBuildsBelow = false;
    private Boolean greenColors = false;
    private transient List<XFPanelEntry> entries;
    private transient Map<Queue.Item, Integer> placeInQueue = new HashMap<Queue.Item, Integer>();

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 1;
    }

    public XFColors getColors() {
        if (this.getgreenColors().booleanValue()) {
            this.colors = XFColors.GREEN;
            return this.colors;
        }
        this.colors = XFColors.DEFAULT;
        return this.colors;
    }

    public Boolean getFullHD() {
        return this.fullHD;
    }

    public Boolean getShowDescription() {
        if (this.showDescription == null) {
            this.showDescription = false;
        }
        return this.showDescription;
    }

    public Boolean getShowBrokenBuildCount() {
        if (this.showBrokenBuildCount == null) {
            this.showBrokenBuildCount = false;
        }
        return this.showBrokenBuildCount;
    }

    public Boolean getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = false;
        }
        return this.sortDescending;
    }

    public Boolean getfailedBuildsBelow() {
        if (this.failedBuildsBelow == null) {
            this.failedBuildsBelow = false;
        }
        return this.failedBuildsBelow;
    }

    public Boolean getgreenColors() {
        if (this.greenColors == null) {
            this.greenColors = false;
        }
        return this.greenColors;
    }

    public Boolean getShowZeroTestCounts() {
        if (this.showZeroTestCounts == null) {
            this.showZeroTestCounts = true;
        }
        return this.showZeroTestCounts;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                ents.add(new XFPanelEntry(job));
            }
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Collection<XFPanelEntry> sortFailedBuildsBelow(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            ArrayList<XFPanelEntry> entsS = new ArrayList<XFPanelEntry>();
            ArrayList<XFPanelEntry> entsF = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                String result = job.getLastCompletedBuild().getResult().toString();
                if (result == "SUCCESS") {
                    entsS.add(new XFPanelEntry(job));
                    continue;
                }
                entsF.add(new XFPanelEntry(job));
            }
            ents.addAll(entsS);
            ents.addAll(entsF);
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        try {
            this.numColumns = Integer.parseInt(req.getParameter("numColumns"));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException("Number of columns currently supported is 1 or 2.", "numColumns");
        }
        try {
            this.refresh = Integer.parseInt(req.getParameter("refresh"));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException("Refresh time must be a positive integer.", "refresh");
        }
        this.fullHD = Boolean.parseBoolean(req.getParameter("fullHD"));
        this.showDescription = Boolean.parseBoolean(req.getParameter("showDescription"));
        this.showBrokenBuildCount = Boolean.parseBoolean(req.getParameter("showBrokenBuildCount"));
        this.sortDescending = Boolean.parseBoolean(req.getParameter("sortDescending"));
        this.failedBuildsBelow = Boolean.parseBoolean(req.getParameter("failedBuildsBelow"));
        this.greenColors = Boolean.parseBoolean(req.getParameter("greenColors"));
        this.showZeroTestCounts = Boolean.parseBoolean(req.getParameter("showZeroTestCounts"));
    }

    public static final class XFColors {
        private String okBG;
        private String okFG;
        private String failedBG;
        private String failedFG;
        private String brokenBG;
        private String brokenFG;
        private String otherBG;
        private String otherFG;
        public static final XFColors DEFAULT = new XFColors("#7E7EFF", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");
        public static final XFColors GREEN = new XFColors("#267526", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");

        public XFColors(String okBG, String okFG, String failedBG, String failedFG, String brokenBG, String brokenFG, String otherBG, String otherFG) {
            this.okBG = okBG;
            this.okFG = okFG;
            this.failedBG = failedBG;
            this.failedFG = failedFG;
            this.brokenBG = brokenBG;
            this.brokenFG = brokenFG;
            this.otherBG = otherBG;
            this.otherFG = otherFG;
        }

        public String getOkBG() {
            return this.okBG;
        }

        public String getOkFG() {
            return this.okFG;
        }

        public String getFailedBG() {
            return this.failedBG;
        }

        public String getFailedFG() {
            return this.failedFG;
        }

        public String getBrokenBG() {
            return this.brokenBG;
        }

        public String getBrokenFG() {
            return this.brokenFG;
        }

        public String getOtherBG() {
            return this.otherBG;
        }

        public String getOtherFG() {
            return this.otherFG;
        }
    }

    @Extension
    public static final class XFPanelViewDescriptor
    extends ViewDescriptor {
        public static final String REFRESH_MSG = "Refresh time must be a positive integer.";
        public static final String MSG = "Number of columns currently supported is 1 or 2.";

        public String getDisplayName() {
            return "eXtreme Feedback Panel";
        }

        public FormValidation doCheckNumColumns(StaplerRequest req, StaplerResponse resp) {
            block4: {
                String num = Util.fixEmptyAndTrim((String)req.getParameter("numColumns"));
                if (num != null) {
                    try {
                        int i = Integer.parseInt(num);
                        if (i < 1 || i > 2) {
                            return FormValidation.error((String)MSG);
                        }
                        break block4;
                    }
                    catch (NumberFormatException e) {
                        return FormValidation.error((String)MSG);
                    }
                }
                return FormValidation.error((String)MSG);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRefresh(StaplerRequest req) {
            return FormValidation.validatePositiveInteger((String)req.getParameter("refresh"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XFPanelEntry {
        private Job<?, ?> job;
        private String backgroundColor;
        private String color;
        private Boolean broken;
        private Boolean building = false;
        private Boolean queued = false;
        private Integer queueNumber;

        public XFPanelEntry(Job<?, ?> job) {
            this.job = job;
            this.findStatus();
        }

        public Job<?, ?> getJob() {
            return this.job;
        }

        public String getName() {
            String label = this.job.getName().toUpperCase();
            if (XFPanelView.this.getShowDescription().booleanValue() && !this.job.getDescription().isEmpty()) {
                label = label + ": " + this.job.getDescription();
            }
            return label;
        }

        public Boolean getQueued() {
            return this.job.isInQueue();
        }

        public Integer getQueueNumber() {
            return XFPanelView.this.placeInQueue == null ? null : (Integer)XFPanelView.this.placeInQueue.get(this.job.getQueueItem());
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean getBroken() {
            return this.broken;
        }

        public Boolean getBuilding() {
            return this.building;
        }

        public String getUrl() {
            return this.job.getUrl() + "lastBuild";
        }

        public List<Run<?, ?>> getBuildsInProgress() {
            ArrayList runs = new ArrayList();
            Run run = this.job.getLastBuild();
            if (run.isBuilding()) {
                runs.add(run);
            }
            for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
                runs.add(prev);
            }
            return runs;
        }

        public int getTestCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getTotalCount() : 0;
            }
            return 0;
        }

        public int getFailCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getFailCount() : 0;
            }
            return 0;
        }

        public int getSuccessCount() {
            return this.getTestCount() - this.getFailCount();
        }

        public int getNumberOfFailedBuilds() {
            int lastSuccessfulNumber = this.job.getLastSuccessfulBuild().getNumber();
            int lastNumber = this.job.getLastCompletedBuild().getNumber();
            int numberOfFailedBuilds = lastNumber - lastSuccessfulNumber;
            return numberOfFailedBuilds;
        }

        public String getDiff() {
            Run<?, ?> previous;
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
                if (tests != null && prevTests != null) {
                    int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                    int prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount();
                    return Functions.getDiffString((int)(currentSuccess - prevSuccess));
                }
            }
            return "";
        }

        private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
            Run r;
            for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
            }
            return r;
        }

        public String getCulprit() {
            Run run = this.job.getLastBuild();
            StringBuffer culprits = new StringBuffer();
            String culprit = " - ";
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                Iterator it = build.getCulprits().iterator();
                while (it.hasNext()) {
                    culprits.append(((User)it.next()).getFullName().toUpperCase());
                    if (!it.hasNext()) continue;
                    culprits.append(", ");
                }
                if (culprits.length() > 0) {
                    culprit = culprits.toString();
                }
            }
            return culprit;
        }

        public String getDiffColor() {
            String diff = this.getDiff().trim();
            if (diff.length() > 0) {
                if (diff.startsWith("-")) {
                    return "#FF0000";
                }
                return "#00FF00";
            }
            return "#FFFFFF";
        }

        public String getSuccessPercentage() {
            if (this.getTestCount() > 0) {
                Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
                return NumberFormat.getPercentInstance().format(perc);
            }
            return "";
        }

        private void findStatus() {
            switch (this.job.getIconColor()) {
                case BLUE_ANIME: {
                    this.building = true;
                }
                case BLUE: {
                    this.backgroundColor = XFPanelView.this.getColors().getOkBG();
                    this.color = XFPanelView.this.colors.getOkFG();
                    this.broken = false;
                    break;
                }
                case YELLOW_ANIME: {
                    this.building = true;
                }
                case YELLOW: {
                    this.backgroundColor = XFPanelView.this.getColors().getFailedBG();
                    this.color = XFPanelView.this.colors.getFailedFG();
                    this.broken = false;
                    break;
                }
                case RED_ANIME: {
                    this.building = true;
                }
                case RED: {
                    this.backgroundColor = XFPanelView.this.getColors().getBrokenBG();
                    this.color = XFPanelView.this.colors.getBrokenFG();
                    this.broken = true;
                    break;
                }
                case GREY_ANIME: 
                case DISABLED_ANIME: {
                    this.building = true;
                }
                default: {
                    this.backgroundColor = XFPanelView.this.getColors().getOtherBG();
                    this.color = XFPanelView.this.colors.getOtherFG();
                    this.broken = true;
                }
            }
        }
    }
}

