/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xshell;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.xshell.Messages;
import hudson.plugins.xshell.XShellDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XShellBuilder
extends Builder {
    @Extension
    public static final XShellDescriptor DESCRIPTOR = new XShellDescriptor();
    private static final boolean DEBUG = false;
    private final String commandLine;
    private final Boolean executeFromWorkingDir;

    public String getCommandLine() {
        return this.commandLine;
    }

    public Boolean getExecuteFromWorkingDir() {
        return this.executeFromWorkingDir;
    }

    @DataBoundConstructor
    public XShellBuilder(String commandLine, Boolean executeFromWorkingDir) {
        this.commandLine = Util.fixEmptyAndTrim((String)commandLine);
        this.executeFromWorkingDir = executeFromWorkingDir;
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        if (this.commandLine != null) {
            args.addTokenized(launcher.isUnix() && this.executeFromWorkingDir != false ? "./" + this.commandLine : this.commandLine);
        }
        if (!launcher.isUnix()) {
            args.add(new String[]{"&&", "exit", "%%ERRORLEVEL%%"});
            args = new ArgumentListBuilder().add(new String[]{"cmd.exe", "/C"}).addQuoted(args.toStringWithQuote());
        }
        try {
            int result = launcher.launch().cmds(args).envs((Map)env).stdout((TaskListener)listener).pwd(build.getModuleRoot()).join();
            return result == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.XShell_ExecFailed();
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }
}

