/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.thalesgroup.hudson.plugins.xunit.Messages;
import com.thalesgroup.hudson.plugins.xunit.XUnitConfig;
import com.thalesgroup.hudson.plugins.xunit.model.TypeConfig;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Publisher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private XUnitConfig config = new XUnitConfig();
    public static final XUnitDescriptor DESCRIPTOR = new XUnitDescriptor();

    public Action getProjectAction(Project project) {
        return new TestResultProjectAction((AbstractProject)project);
    }

    public XUnitConfig getConfig() {
        return this.config;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = false;
        FilePath junitTargetFilePath = new FilePath(build.getProject().getWorkspace(), "xunitTemp");
        if (junitTargetFilePath.exists()) {
            junitTargetFilePath.deleteRecursive();
        }
        junitTargetFilePath.mkdirs();
        FilePath[] moduleRoots = build.getProject().getModuleRoots();
        boolean multipleModuleRoots = moduleRoots != null && moduleRoots.length > 1;
        FilePath moduleRoot = multipleModuleRoots ? build.getProject().getWorkspace() : build.getProject().getModuleRoot();
        try {
            XUnitTransformer transformer = new XUnitTransformer(listener, this.config, junitTargetFilePath);
            result = (Boolean)moduleRoot.act((FilePath.FileCallable)transformer);
            if (!result) {
                build.setResult(Result.FAILURE);
            } else {
                result = this.recordTestResult(build, listener, junitTargetFilePath, "TEST-*.xml");
            }
        }
        catch (IOException2 ioe) {
            throw new IOException("xUnithasn't been perfomed correctly.", ioe);
        }
        finally {
            try {
                junitTargetFilePath.deleteRecursive();
            }
            catch (IOException ioe) {
            }
            catch (InterruptedException ie) {}
        }
        return result;
    }

    public XUnitDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private boolean recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, FilePath junitTargetFilePath, String junitFilePattern) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = this.getTestResult(junitTargetFilePath, junitFilePattern, build, existingTestResults, buildTime);
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            if (build.getResult() == Result.FAILURE) {
                return true;
            }
            listener.getLogger().println(e.getMessage());
            build.setResult(Result.FAILURE);
            return true;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        return true;
    }

    private TestResult getTestResult(FilePath temporaryJunitFilePath, final String junitFilePattern, AbstractBuild<?, ?> build, final TestResult existingTestResults, final long buildTime) throws IOException, InterruptedException {
        final File temporaryJunitDirFile = new File(temporaryJunitFilePath.toURI());
        TestResult result = (TestResult)build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

            public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                FileSet fs = Util.createFileSet((File)temporaryJunitDirFile, (String)junitFilePattern);
                DirectoryScanner ds = fs.getDirectoryScanner();
                String[] files = ds.getIncludedFiles();
                if (files.length == 0) {
                    throw new AbortException("No test report files were found. Configuration error?");
                }
                if (existingTestResults == null) {
                    return new TestResult(buildTime, ds);
                }
                existingTestResults.parse(buildTime, ds);
                return existingTestResults;
            }
        });
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class XUnitDescriptor
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptor() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public Publisher newInstance(StaplerRequest req) throws Descriptor.FormException {
            XUnitPublisher pub = new XUnitPublisher();
            List<TypeConfig> tools = pub.getConfig().getTestTools();
            for (TypeConfig typeConfig : tools) {
                String value = req.getParameter("config." + typeConfig.getName() + ".pattern");
                typeConfig.setPattern(value);
            }
            pub.getConfig().getCustomTools().addAll(req.bindParametersToList(TypeConfig.class, "xunit.customentry."));
            return pub;
        }

        public XUnitConfig getConfig() {
            return new XUnitConfig();
        }
    }
}

