/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.transformer;

import com.thalesgroup.hudson.plugins.xunit.XUnitConfig;
import com.thalesgroup.hudson.plugins.xunit.model.TypeConfig;
import com.thalesgroup.hudson.plugins.xunit.types.TypeDescriptor;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final String JUNIT_FILE_POSTFIX = ".xml";
    private static final String JUNIT_FILE_PREFIX = "TEST-";
    private BuildListener listener;
    private XUnitConfig config = new XUnitConfig();
    private FilePath junitOutputPath = null;

    public XUnitTransformer(BuildListener listener, XUnitConfig config, FilePath junitOutputPath) {
        this.listener = listener;
        this.config = config;
        this.junitOutputPath = junitOutputPath;
    }

    private boolean isEmpty(String field) {
        if (field == null) {
            return true;
        }
        return field.trim().length() == 0;
    }

    private boolean isNotCompleteCustomConfigEntry(TypeConfig testTool) {
        boolean result = this.isEmpty(testTool.getPattern());
        result = result || this.isEmpty(testTool.getLabel());
        result = result || this.isEmpty(testTool.getStylesheet());
        return result;
    }

    private boolean isValidCustomConfigEntry(File moduleRoot, TypeConfig testTool) {
        boolean result = !this.isNotCompleteCustomConfigEntry(testTool);
        File stylesheetFile = new File(moduleRoot, testTool.getStylesheet());
        if (result && !stylesheetFile.exists()) {
            String msg = "The custom stylesheet '" + testTool.getStylesheet() + "' for the tool '" + testTool.getLabel() + "' doesn't exist.";
            XUnitLog.log((BuildListener)this.listener, (String)msg);
            return false;
        }
        return result;
    }

    public Boolean invoke(File moduleRoot, VirtualChannel channel) throws IOException {
        try {
            boolean result;
            boolean isInvoked = false;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder xmlDocumentBuilder = factory.newDocumentBuilder();
            Transformer writerTransformer = transformerFactory.newTransformer();
            for (TypeConfig testTool : this.config.getTestTools()) {
                if (this.isEmpty(testTool.getPattern())) continue;
                isInvoked = true;
                result = this.processTool(moduleRoot, transformerFactory, xmlDocumentBuilder, writerTransformer, testTool, new StreamSource(this.getClass().getResourceAsStream(((TypeDescriptor)XUnitConfig.TOOLS.get(testTool.getName())).getXslPath())));
                if (result) continue;
                return false;
            }
            for (TypeConfig testTool : this.config.getCustomTools()) {
                if (this.isValidCustomConfigEntry(moduleRoot, testTool)) {
                    isInvoked = true;
                    result = this.processTool(moduleRoot, transformerFactory, xmlDocumentBuilder, writerTransformer, testTool, new StreamSource(new File(moduleRoot, testTool.getStylesheet())));
                    if (result) continue;
                    return false;
                }
                if (!this.isNotCompleteCustomConfigEntry(testTool)) continue;
                String msg = "[ERROR] - There is an invalid configuration for the following entries '" + testTool.getLabel() + "':'" + testTool.getPattern() + "':'" + testTool.getStylesheet() + "' into the custom testing frameworks section.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
            if (!isInvoked) {
                String msg = "[ERROR] - No test report files were found. Configuration error?";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException2("Problem on converting into JUnit reports.", (Throwable)e);
        }
        return true;
    }

    private boolean processTool(File moduleRoot, TransformerFactory transformerFactory, DocumentBuilder xmlDocumentBuilder, Transformer writerTransformer, TypeConfig testTool, StreamSource stylesheet) throws TransformerException, IOException, InterruptedException {
        Transformer toolXMLTransformer = transformerFactory.newTransformer(stylesheet);
        String[] resultFiles = this.findtReports(moduleRoot, testTool.getPattern());
        if (resultFiles.length == 0) {
            String msg = "[ERROR] - No test report file(s) were found with the pattern '" + testTool.getPattern() + "' relative to '" + moduleRoot + "' for the testing framework '" + testTool.getLabel() + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + testTool.getLabel() + "'?";
            XUnitLog.log((BuildListener)this.listener, (String)msg);
            return false;
        }
        XUnitLog.log((BuildListener)this.listener, (String)("[" + testTool.getLabel() + "] - Processing " + resultFiles.length + " files with the pattern '" + testTool.getPattern() + "' relative to '" + moduleRoot + "'."));
        for (String resultFile : resultFiles) {
            File resultFilePathFile = new File(moduleRoot, resultFile);
            if (resultFilePathFile.length() == 0L) {
                String msg = "[WARNING] - The file '" + resultFilePathFile.getPath() + "' is empty. This file has been ignored.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                continue;
            }
            FilePath junitTargetFile = new FilePath(this.junitOutputPath, "file" + resultFilePathFile.hashCode() + JUNIT_FILE_POSTFIX);
            try {
                toolXMLTransformer.transform(new StreamSource(resultFilePathFile), new StreamResult(new File(junitTargetFile.toURI())));
                this.processJUnitFile(xmlDocumentBuilder, writerTransformer, junitTargetFile, this.junitOutputPath);
            }
            catch (TransformerException te) {
                String msg = "[ERROR] - Couldn't convert the file '" + resultFilePathFile.getPath() + "' into a JUnit file.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
            catch (SAXException te) {
                String msg = "[ERROR] - Couldn't split JUnit testsuites for the file '" + resultFile + "' into JUnit files with one testsuite.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
        }
        return true;
    }

    private String[] findtReports(File parentPath, String pattern) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] xunitFiles = ds.getIncludedFiles();
        return xunitFiles;
    }

    private void processJUnitFile(DocumentBuilder xmlDocumentBuilder, Transformer writerTransformer, FilePath junitFile, FilePath junitOutputPath) throws SAXException, IOException, TransformerException, InterruptedException {
        Document document = xmlDocumentBuilder.parse(new File(junitFile.toURI()));
        NodeList testsuitesNodeList = document.getElementsByTagName("testsuites");
        if (testsuitesNodeList == null || testsuitesNodeList.getLength() == 0) {
            junitFile.renameTo(new FilePath(junitFile.getParent(), JUNIT_FILE_PREFIX + junitFile.getName() + JUNIT_FILE_POSTFIX));
            return;
        }
        this.splitJunitFile(writerTransformer, testsuitesNodeList, junitOutputPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitJunitFile(Transformer writerTransformer, NodeList testsuitesNodeList, FilePath junitOutputPath) throws IOException, InterruptedException, TransformerException {
        NodeList elementsByTagName = ((Element)testsuitesNodeList.item(0)).getElementsByTagName("testsuite");
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element element = (Element)elementsByTagName.item(i);
            DOMSource source = new DOMSource(element);
            FilePath junitOutputFile = new FilePath(junitOutputPath, JUNIT_FILE_PREFIX + element.getAttribute("name") + JUNIT_FILE_POSTFIX);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(junitOutputFile.toURI()));
            try {
                StreamResult result = new StreamResult(fileOutputStream);
                writerTransformer.transform(source, result);
                continue;
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

