/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.transformer;

import com.thalesgroup.hudson.plugins.xunit.types.XUnitType;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private static final String JUNIT_FILE_POSTFIX = ".xml";
    private static final String JUNIT_FILE_PREFIX = "TEST-";
    private BuildListener listener;
    private long buildTime;
    private EnvVars env;
    private XUnitType[] types;
    private FilePath junitOutputPath = null;

    public XUnitTransformer(BuildListener listener, long buildTime, EnvVars env, XUnitType[] types, FilePath junitOutputPath) {
        this.listener = listener;
        this.buildTime = buildTime;
        this.env = env;
        this.types = types;
        this.junitOutputPath = junitOutputPath;
    }

    private boolean isEmpty(String field) {
        if (field == null) {
            return true;
        }
        return field.trim().length() == 0;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        try {
            boolean isInvoked = false;
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder xmlDocumentBuilder = factory.newDocumentBuilder();
            Transformer writerTransformer = transformerFactory.newTransformer();
            for (XUnitType tool : this.types) {
                if (this.isEmpty(tool.getPattern())) continue;
                isInvoked = true;
                InputStream is = tool.getClass().getResourceAsStream(tool.getXsl());
                boolean result = this.processTool(ws, transformerFactory, xmlDocumentBuilder, writerTransformer, tool, new StreamSource(is));
                if (result) continue;
                return result;
            }
            if (!isInvoked) {
                String msg = "[ERROR] - No test report files were found. Configuration error?";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
        }
        catch (Exception e) {
            throw new IOException2("Problem on converting into JUnit reports.", (Throwable)e);
        }
        return true;
    }

    private boolean validateXUnitResultFile(File fileXUnitReportFile) throws FactoryConfigurationError {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.parse(fileXUnitReportFile);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<String> findtReports(XUnitType testTool, long buildTime, File parentPath, String pattern) throws AbortException {
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        File baseDir = ds.getBasedir();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = "[ERROR] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + testTool.getDescriptor().getDisplayName() + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + testTool.getDescriptor().getDisplayName() + "'?";
            XUnitLog.log((BuildListener)this.listener, (String)msg);
            return null;
        }
        boolean parsed = false;
        ArrayList<String> resultFiles = new ArrayList<String>();
        for (String value : xunitFiles) {
            File reportFile = new File(baseDir, value);
            if (buildTime - 3000L > reportFile.lastModified()) continue;
            resultFiles.add(value);
            parsed = true;
        }
        if (!parsed) {
            long localTime = System.currentTimeMillis();
            if (localTime < buildTime - 1000L) {
                String msg = "[ERROR] - Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return null;
            }
            File f = new File(baseDir, xunitFiles[0]);
            String msg = "[ERROR] - " + String.format("Test reports were found but none of them are new. Did tests run? \nFor example, %s is %s old\n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified())));
            XUnitLog.log((BuildListener)this.listener, (String)msg);
            return null;
        }
        return resultFiles;
    }

    private boolean processTool(File moduleRoot, TransformerFactory transformerFactory, DocumentBuilder xmlDocumentBuilder, Transformer writerTransformer, XUnitType testTool, StreamSource stylesheet) throws TransformerException, IOException, InterruptedException {
        Transformer toolXMLTransformer = transformerFactory.newTransformer(stylesheet);
        if (toolXMLTransformer == null) {
            throw new InterruptedException("Problem on making the tool transformer.");
        }
        String curPattern = testTool.getPattern();
        curPattern = curPattern.replaceAll("[\t\r\n]+", " ");
        List resultFiles = this.findtReports(testTool, this.buildTime, moduleRoot, curPattern = Util.replaceMacro((String)curPattern, (Map)this.env));
        if (resultFiles == null) {
            return false;
        }
        XUnitLog.log((BuildListener)this.listener, (String)("[" + testTool.getDescriptor().getDisplayName() + "] - Processing " + resultFiles.size() + " files with the pattern '" + testTool.getPattern() + "' relative to '" + moduleRoot + "'."));
        boolean hasInvalidateFiles = false;
        for (String resultFile : resultFiles) {
            File resultFilePathFile = new File(moduleRoot, resultFile);
            if (resultFilePathFile.length() == 0L) {
                String msg = "[WARNING] - The file '" + resultFilePathFile.getPath() + "' is empty. This file has been ignored.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                continue;
            }
            if (!this.validateXUnitResultFile(resultFilePathFile)) {
                hasInvalidateFiles = true;
                XUnitLog.log((BuildListener)this.listener, (String)("[WARNING] - The file '" + resultFilePathFile + "' is an invalid file. It has been ignored."));
                continue;
            }
            FilePath junitTargetFile = new FilePath(this.junitOutputPath, "file" + resultFilePathFile.hashCode() + JUNIT_FILE_POSTFIX);
            try {
                toolXMLTransformer.transform(new StreamSource(resultFilePathFile), new StreamResult(new File(junitTargetFile.toURI())));
                this.processJUnitFile(xmlDocumentBuilder, writerTransformer, junitTargetFile, this.junitOutputPath);
            }
            catch (TransformerException te) {
                String msg = "[ERROR] - Couldn't convert the file '" + resultFilePathFile.getPath() + "' into a JUnit file.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
            catch (SAXException te) {
                String msg = "[ERROR] - Couldn't split JUnit testsuites for the file '" + resultFile + "' into JUnit files with one testsuite.";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
        }
        return true;
    }

    private void processJUnitFile(DocumentBuilder xmlDocumentBuilder, Transformer writerTransformer, FilePath junitFile, FilePath junitOutputPath) throws SAXException, IOException, TransformerException, InterruptedException {
        Document document = xmlDocumentBuilder.parse(new File(junitFile.toURI()));
        NodeList testsuitesNodeList = document.getElementsByTagName("testsuites");
        if (testsuitesNodeList == null || testsuitesNodeList.getLength() == 0) {
            junitFile.renameTo(new FilePath(junitFile.getParent(), JUNIT_FILE_PREFIX + junitFile.getName() + JUNIT_FILE_POSTFIX));
            return;
        }
        this.splitJunitFile(writerTransformer, testsuitesNodeList, junitOutputPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void splitJunitFile(Transformer writerTransformer, NodeList testsuitesNodeList, FilePath junitOutputPath) throws IOException, InterruptedException, TransformerException {
        NodeList elementsByTagName = ((Element)testsuitesNodeList.item(0)).getElementsByTagName("testsuite");
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Element element = (Element)elementsByTagName.item(i);
            DOMSource source = new DOMSource(element);
            String suiteName = element.getAttribute("name");
            FilePath junitOutputFile = new FilePath(junitOutputPath, JUNIT_FILE_PREFIX + suiteName.hashCode() + JUNIT_FILE_POSTFIX);
            FileOutputStream fileOutputStream = new FileOutputStream(new File(junitOutputFile.toURI()));
            try {
                StreamResult result = new StreamResult(fileOutputStream);
                writerTransformer.transform(source, result);
                continue;
            }
            finally {
                fileOutputStream.close();
            }
        }
    }
}

