/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.thalesgroup.hudson.plugins.xunit.XUnitConfig;
import com.thalesgroup.hudson.plugins.xunit.XUnitPublisher;
import com.thalesgroup.hudson.plugins.xunit.model.TypeConfig;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import com.thalesgroup.hudson.plugins.xunit.types.BoostTestType;
import com.thalesgroup.hudson.plugins.xunit.types.CppUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.MSTestType;
import com.thalesgroup.hudson.plugins.xunit.types.NUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.PHPUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.UnitTestType;
import com.thalesgroup.hudson.plugins.xunit.types.XUnitType;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.IOException2;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public XUnitType[] types;
    @Deprecated
    private transient XUnitConfig config;

    public XUnitPublisher(XUnitType[] types) {
        this.types = types;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitLog.log((BuildListener)listener, (String)"Starting to record.");
        Result previousResult = build.getResult();
        FilePath junitTargetFilePath = new FilePath(build.getWorkspace(), "xunitTemp");
        if (junitTargetFilePath.exists()) {
            junitTargetFilePath.deleteRecursive();
        }
        junitTargetFilePath.mkdirs();
        try {
            XUnitTransformer transformer = new XUnitTransformer(listener, build.getTimestamp().getTimeInMillis(), build.getEnvironment((TaskListener)listener), this.types, junitTargetFilePath);
            boolean result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)transformer);
            if (!result) {
                build.setResult(Result.FAILURE);
                XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
                boolean bl = true;
                return bl;
            }
            Result curResult = this.recordTestResult(build, listener, junitTargetFilePath, "TEST-*.xml");
            if (previousResult.isWorseOrEqualTo(curResult)) {
                build.setResult(previousResult);
                XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
                boolean bl = true;
                return bl;
            }
            XUnitLog.log((BuildListener)listener, (String)("Setting the build status to " + curResult));
            build.setResult(curResult);
            XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
            boolean bl = true;
            return bl;
        }
        catch (IOException2 ioe) {
            throw new IOException2("The plugin hasn't been performed correctly.", (Throwable)ioe);
        }
        finally {
            try {
                junitTargetFilePath.deleteRecursive();
            }
            catch (IOException ioe) {
                XUnitLog.log((BuildListener)listener, (String)("The plugin hasn't been performed correctly: " + ioe.getMessage()));
                return false;
            }
            catch (InterruptedException ie) {
                XUnitLog.log((BuildListener)listener, (String)("The plugin hasn't been performed correctly: " + ie.getMessage()));
                return false;
            }
        }
    }

    private Result recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, FilePath junitTargetFilePath, String junitFilePattern) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            long nowMaster = System.currentTimeMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new ParseResultCallable(junitTargetFilePath, junitFilePattern, existingTestResults, buildTime, nowMaster, null));
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            listener.getLogger().println(e.getMessage());
            return Result.FAILURE;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private Object readResolve() {
        try {
            if (this.config != null) {
                HashMap<String, Class> map = new HashMap<String, Class>();
                map.put("phpunit", PHPUnitType.class);
                map.put("cppunit", CppUnitType.class);
                map.put("unittest", UnitTestType.class);
                map.put("nunit", NUnitType.class);
                map.put("mstest", MSTestType.class);
                map.put("boosttest", BoostTestType.class);
                ArrayList<XUnitType> xunitTypeList = new ArrayList<XUnitType>();
                this.types = new XUnitType[0];
                for (TypeConfig typeConfig : this.config.getTestTools()) {
                    String pattern = typeConfig.getPattern();
                    if (pattern == null || pattern.trim().length() == 0) continue;
                    Constructor constructor = ((Class)map.get(typeConfig.getName())).getConstructor(String.class);
                    XUnitType xunitType = (XUnitType)constructor.newInstance(pattern);
                    xunitTypeList.add(xunitType);
                }
                this.types = xunitTypeList.toArray(new XUnitType[xunitTypeList.size()]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }
}

