/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.thalesgroup.hudson.plugins.xunit.Messages;
import com.thalesgroup.hudson.plugins.xunit.XUnitConfig;
import com.thalesgroup.hudson.plugins.xunit.model.TypeConfig;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import com.thalesgroup.hudson.plugins.xunit.types.BoostTestType;
import com.thalesgroup.hudson.plugins.xunit.types.CppUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.MSTestType;
import com.thalesgroup.hudson.plugins.xunit.types.NUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.PHPUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.UnitTestType;
import com.thalesgroup.hudson.plugins.xunit.types.XUnitType;
import com.thalesgroup.hudson.plugins.xunit.types.XUnitTypeDescriptor;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    public XUnitType[] types;
    @Deprecated
    private transient XUnitConfig config;

    public XUnitPublisher(XUnitType[] types) {
        this.types = types;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TestResultProjectAction(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitLog.log(listener, "Starting to record.");
        Result previousResult = build.getResult();
        FilePath junitTargetFilePath = new FilePath(build.getWorkspace(), "xunitTemp");
        if (junitTargetFilePath.exists()) {
            junitTargetFilePath.deleteRecursive();
        }
        junitTargetFilePath.mkdirs();
        try {
            XUnitTransformer transformer = new XUnitTransformer(listener, build.getTimestamp().getTimeInMillis(), build.getEnvironment((TaskListener)listener), this.types, junitTargetFilePath);
            boolean result = (Boolean)build.getWorkspace().act((FilePath.FileCallable)transformer);
            if (!result) {
                build.setResult(Result.FAILURE);
                XUnitLog.log(listener, "Stopping recording.");
                boolean bl = true;
                return bl;
            }
            Result curResult = this.recordTestResult(build, listener, junitTargetFilePath, "TEST-*.xml");
            if (previousResult.isWorseOrEqualTo(curResult)) {
                build.setResult(previousResult);
                XUnitLog.log(listener, "Stopping recording.");
                boolean bl = true;
                return bl;
            }
            XUnitLog.log(listener, "Setting the build status to " + curResult);
            build.setResult(curResult);
            XUnitLog.log(listener, "Stopping recording.");
            boolean bl = true;
            return bl;
        }
        catch (IOException2 ioe) {
            throw new IOException2("The plugin hasn't been performed correctly.", (Throwable)ioe);
        }
        finally {
            try {
                junitTargetFilePath.deleteRecursive();
            }
            catch (IOException ioe) {
                XUnitLog.log(listener, "The plugin hasn't been performed correctly: " + ioe.getMessage());
                return false;
            }
            catch (InterruptedException ie) {
                XUnitLog.log(listener, "The plugin hasn't been performed correctly: " + ie.getMessage());
                return false;
            }
        }
    }

    private Result recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, FilePath junitTargetFilePath, String junitFilePattern) throws InterruptedException, IOException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        try {
            long buildTime = build.getTimestamp().getTimeInMillis();
            long nowMaster = System.currentTimeMillis();
            TestResult existingTestResults = null;
            if (existingAction != null) {
                existingTestResults = existingAction.getResult();
            }
            TestResult result = (TestResult)build.getWorkspace().act((FilePath.FileCallable)new ParseResultCallable(junitTargetFilePath, junitFilePattern, existingTestResults, buildTime, nowMaster));
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                throw new AbortException("None of the test reports contained any result");
            }
        }
        catch (AbortException e) {
            listener.getLogger().println(e.getMessage());
            return Result.FAILURE;
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
        if (action.getResult().getFailCount() > 0) {
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private Object readResolve() {
        try {
            if (this.config != null) {
                HashMap<String, Class> map = new HashMap<String, Class>();
                map.put("phpunit", PHPUnitType.class);
                map.put("cppunit", CppUnitType.class);
                map.put("unittest", UnitTestType.class);
                map.put("nunit", NUnitType.class);
                map.put("mstest", MSTestType.class);
                map.put("boosttest", BoostTestType.class);
                ArrayList<XUnitType> xunitTypeList = new ArrayList<XUnitType>();
                this.types = new XUnitType[0];
                for (TypeConfig typeConfig : this.config.getTestTools()) {
                    String pattern = typeConfig.getPattern();
                    if (pattern == null || pattern.trim().length() == 0) continue;
                    Constructor constructor = ((Class)map.get(typeConfig.getName())).getConstructor(String.class);
                    XUnitType xunitType = (XUnitType)constructor.newInstance(pattern);
                    xunitTypeList.add(xunitType);
                }
                this.types = xunitTypeList.toArray(new XUnitType[xunitTypeList.size()]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class XUnitDescriptorPublisher
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptorPublisher() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<XUnitType, XUnitTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return XUnitTypeDescriptor.all();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List types = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"tools", this.getListXUnitTypeDescriptors());
            return new XUnitPublisher(types.toArray(new XUnitType[types.size()]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ParseResultCallable
    implements FilePath.FileCallable<TestResult> {
        final FilePath temporaryJunitFilePath;
        final String junitFilePattern;
        final TestResult existingTestResults;
        long buildTime;
        long nowMaster;

        private ParseResultCallable(FilePath temporaryJunitFilePath, String junitFilePattern, TestResult existingTestResults, long buildTime, long nowMaster) {
            this.temporaryJunitFilePath = temporaryJunitFilePath;
            this.junitFilePattern = junitFilePattern;
            this.existingTestResults = existingTestResults;
            this.buildTime = buildTime;
            this.nowMaster = nowMaster;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            File temporaryJunitDirFile = null;
            try {
                temporaryJunitDirFile = new File(this.temporaryJunitFilePath.toURI());
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            FileSet fs = Util.createFileSet(temporaryJunitDirFile, (String)this.junitFilePattern);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                throw new AbortException("No test report files were found. Configuration error?");
            }
            if (this.existingTestResults == null) {
                return new TestResult(this.buildTime + (nowSlave - this.nowMaster), ds);
            }
            this.existingTestResults.parse(this.buildTime, ds);
            return this.existingTestResults;
        }
    }
}

