/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.thalesgroup.dtkit.metrics.api.InputMetric;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.hudson.plugins.xunit.Messages;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JUNIT_FILE_PATTERN = "**/TEST-*.xml";
    public TestType[] types;

    public XUnitPublisher(TestType[] types) {
        this.types = types;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    private TestResult getTestResult(AbstractBuild<?, ?> build, final File junitFileDir, final String junitFilePattern, final TestResult existingTestResults, final long buildTime, final long nowMaster) throws XUnitException {
        try {
            return (TestResult)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    FileSet fs = Util.createFileSet((File)junitFileDir, (String)junitFilePattern);
                    DirectoryScanner ds = fs.getDirectoryScanner();
                    String[] files = ds.getIncludedFiles();
                    if (files.length == 0) {
                        throw new IOException("No test report files were found. Configuration error?");
                    }
                    try {
                        if (existingTestResults == null) {
                            return new TestResult(buildTime + (nowSlave - nowMaster), ds);
                        }
                        existingTestResults.parse(buildTime + (nowSlave - nowMaster), ds);
                        return existingTestResults;
                    }
                    catch (IOException ioe) {
                        throw new IOException(ioe);
                    }
                }
            });
        }
        catch (IOException ioe) {
            throw new XUnitException(ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException(ie);
        }
    }

    private void recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, File junitTargetDirectory) throws XUnitException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        TestResult existingTestResults = null;
        if (existingAction != null) {
            existingTestResults = existingAction.getResult();
        }
        TestResult result = this.getTestResult(build, junitTargetDirectory, JUNIT_FILE_PATTERN, existingTestResults, buildTime, nowMaster);
        if (existingAction == null) {
            action = new TestResultAction(build, result, listener);
        } else {
            action = existingAction;
            action.setResult(result, listener);
        }
        if (result.getPassCount() == 0 && result.getFailCount() == 0) {
            throw new XUnitException("None of the test reports contained any result");
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitLog.log(listener, "Starting to record.");
        Result previousResult = build.getResult();
        try {
            final File junitOuputDir = new File(new FilePath(build.getWorkspace(), "generatedJUnitFiles").toURI());
            if (!junitOuputDir.mkdirs()) {
                XUnitLog.log(listener, "Can't create the path " + junitOuputDir + ". Maybe the directory already exists.");
            }
            XUnitTransformer xUnitTransformer = new XUnitTransformer(listener, junitOuputDir, build.getTimeInMillis(), this.types);
            boolean resultTransformation = (Boolean)build.getWorkspace().act((FilePath.FileCallable)xUnitTransformer);
            if (!resultTransformation) {
                build.setResult(Result.FAILURE);
                XUnitLog.log(listener, "Stopping recording.");
                return true;
            }
            this.recordTestResult(build, listener, junitOuputDir);
            TestResultAction testResultAction = (TestResultAction)build.getAction(TestResultAction.class);
            Result curResult = Result.SUCCESS;
            if (testResultAction.getResult().getFailCount() > 0) {
                curResult = Result.UNSTABLE;
            }
            build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                    boolean keep = false;
                    for (TestType tool : XUnitPublisher.this.types) {
                        InputMetric inputMetric = tool.getInputMetric();
                        File parent = new File(junitOuputDir, inputMetric.getToolName());
                        parent.delete();
                    }
                    if (!keep) {
                        junitOuputDir.delete();
                    }
                    return true;
                }
            });
            if (previousResult.isWorseOrEqualTo(curResult)) {
                build.setResult(previousResult);
                XUnitLog.log(listener, "Stopping recording.");
                return true;
            }
            XUnitLog.log(listener, "Setting the build status to " + curResult);
            build.setResult(curResult);
            XUnitLog.log(listener, "Stopping recording.");
            return true;
        }
        catch (XUnitException xe) {
            XUnitLog.log(listener, "The plugin hasn't been performed correctly: " + xe.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class XUnitDescriptorPublisher
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptorPublisher() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List types = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"tools", this.getListXUnitTypeDescriptors());
            return new XUnitPublisher(types.toArray(new TestType[types.size()]));
        }
    }
}

