/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import hudson.Util;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitReportProcessingService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    void set(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean isEmptyPattern(String pattern) {
        return pattern == null || pattern.trim().length() == 0;
    }

    public List<String> findReports(XUnitToolInfo xUnitToolInfo, File parentPath, String pattern) {
        String toolName = xUnitToolInfo.getTestType().getDescriptor().getDisplayName();
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = "[" + toolName + "] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + toolName + "'?";
            this.xUnitLog.error(msg);
        } else {
            String msg = "[" + toolName + "] - " + xunitFiles.length + " test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + toolName + "'.";
            this.xUnitLog.info(msg);
        }
        return Arrays.asList(xunitFiles);
    }

    public boolean checkIfFindsFilesNewFiles(XUnitToolInfo xUnitToolInfo, List<String> files, File workspace) {
        TestType testTool = xUnitToolInfo.getTestType();
        if (testTool.isFaildedIfNotNew()) {
            ArrayList<File> oldResults = new ArrayList<File>();
            for (String value : files) {
                File reportFile = new File(workspace, value);
                if (xUnitToolInfo.getBuildTime() - 3000L <= reportFile.lastModified()) continue;
                oldResults.add(reportFile);
            }
            if (!oldResults.isEmpty()) {
                String msg;
                long localTime = System.currentTimeMillis();
                if (localTime < xUnitToolInfo.getBuildTime() - 1000L) {
                    msg = "Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.";
                    this.xUnitLog.error(msg);
                    return false;
                }
                msg = "Test reports were found but not all of them are new. Did all the tests run?\n";
                for (File f : oldResults) {
                    msg = msg + String.format("  * %s is %s old\n", f, Util.getTimeSpanString((long)(xUnitToolInfo.getBuildTime() - f.lastModified())));
                }
                this.xUnitLog.error(msg);
                return false;
            }
        }
        return true;
    }

    public File getCurrentReport(File root, String name) {
        return new File(root, name);
    }
}

