/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitReportProcessingService;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements Serializable {
    public static final String GENERATED_JUNIT_DIR = "generatedJUnitFiles";
    private TestType[] types;

    public XUnitPublisher(TestType[] types) {
        this.types = types;
    }

    public TestType[] getTypes() {
        return this.types;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    private TestResult getTestResult(AbstractBuild<?, ?> build, String junitFilePattern, TestResult existingTestResults, long buildTime, long nowMaster) throws XUnitException {
        try {
            return (TestResult)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ioe) {
            throw new XUnitException(ioe.getMessage(), (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException(ie.getMessage(), (Throwable)ie);
        }
    }

    private void recordTestResult(AbstractBuild<?, ?> build, BuildListener listener) throws XUnitException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        TestResult existingTestResults = null;
        if (existingAction != null) {
            existingTestResults = existingAction.getResult();
        }
        TestResult result = this.getTestResult(build, "**/TEST-*.xml", existingTestResults, buildTime, nowMaster);
        if (existingAction == null) {
            action = new TestResultAction(build, result, listener);
        } else {
            action = existingAction;
            action.setResult(result, listener);
        }
        if (result.getPassCount() == 0 && result.getFailCount() == 0) {
            throw new XUnitException("None of the test reports contained any result");
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitLog xUnitLog = (XUnitLog)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(XUnitLog.class);
        xUnitLog.info("Starting to record.");
        try {
            XUnitReportProcessingService xUnitReportService = (XUnitReportProcessingService)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(XUnitReportProcessingService.class);
            boolean atLeastOneWarningOrErrorProcess = false;
            for (TestType tool : this.types) {
                xUnitLog.info("Processing " + tool.getDescriptor().getDisplayName());
                if (xUnitReportService.isEmptyPattern(tool.getPattern())) continue;
                String newExpandedPattern = tool.getPattern();
                newExpandedPattern = newExpandedPattern.replaceAll("[\t\r\n]+", " ");
                newExpandedPattern = Util.replaceMacro((String)newExpandedPattern, (Map)build.getEnvironment((TaskListener)listener));
                XUnitToolInfo xUnitToolInfo = new XUnitToolInfo(tool, newExpandedPattern, build.getTimeInMillis());
                XUnitTransformer xUnitTransformer = (XUnitTransformer)Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */}).getInstance(XUnitTransformer.class);
                boolean resultTransformation = (Boolean)build.getWorkspace().act((FilePath.FileCallable)xUnitTransformer);
                if (resultTransformation) continue;
                atLeastOneWarningOrErrorProcess = true;
            }
            if (atLeastOneWarningOrErrorProcess) {
                build.setResult(Result.FAILURE);
                xUnitLog.info("Stopping recording.");
                return true;
            }
            this.recordTestResult(build, listener);
            TestResultAction testResultAction = (TestResultAction)build.getAction(TestResultAction.class);
            Result curResult = Result.SUCCESS;
            if (testResultAction.getResult().getFailCount() > 0) {
                curResult = Result.UNSTABLE;
            }
            boolean resultDeletionOK = true;
            try {
                boolean keepJUnitDirectory = false;
                for (TestType tool : this.types) {
                    InputMetric inputMetric = tool.getInputMetric();
                    if (tool.isDeleteOutputFiles()) {
                        build.getWorkspace().child("generatedJUnitFiles/" + inputMetric.getToolName()).deleteRecursive();
                        continue;
                    }
                    keepJUnitDirectory = true;
                }
                if (!keepJUnitDirectory) {
                    build.getWorkspace().child(GENERATED_JUNIT_DIR).deleteRecursive();
                }
            }
            catch (IOException ioe) {
                resultDeletionOK = false;
            }
            catch (InterruptedException ie) {
                resultDeletionOK = false;
            }
            if (!resultDeletionOK) {
                build.setResult(Result.FAILURE);
                xUnitLog.info("Stopping recording.");
                return true;
            }
            Result previousResult = build.getResult();
            if (previousResult.isWorseOrEqualTo(curResult)) {
                build.setResult(previousResult);
                xUnitLog.info("Stopping recording.");
                return true;
            }
            xUnitLog.info("Setting the build status to " + curResult);
            build.setResult(curResult);
            xUnitLog.info("Stopping recording.");
            return true;
        }
        catch (IOException ie) {
            xUnitLog.error("The plugin hasn't been performed correctly: " + ie.getCause().getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (XUnitException xe) {
            xUnitLog.error("The plugin hasn't been performed correctly: " + xe.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

