/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.transformer;

import com.google.inject.Inject;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitConversionService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitReportProcessingService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitValidationService;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private XUnitReportProcessingService xUnitReportProcessingService;
    private XUnitConversionService xUnitConversionService;
    private XUnitValidationService xUnitValidationService;
    private XUnitToolInfo xUnitToolInfo;
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitReportProcessingService xUnitReportProcessingService, XUnitConversionService xUnitConversionService, XUnitValidationService xUnitValidationService, XUnitToolInfo xUnitToolInfo, XUnitLog xUnitLog) {
        this.xUnitReportProcessingService = xUnitReportProcessingService;
        this.xUnitValidationService = xUnitValidationService;
        this.xUnitConversionService = xUnitConversionService;
        this.xUnitToolInfo = xUnitToolInfo;
        this.xUnitLog = xUnitLog;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        try {
            File junitOuputDir = new File(ws, "generatedJUnitFiles");
            if (!junitOuputDir.mkdirs()) {
                this.xUnitLog.warning("Can't create the path " + junitOuputDir + ". Maybe the directory already exists.");
            }
            String metricName = this.xUnitToolInfo.getToolName();
            List resultFiles = this.xUnitReportProcessingService.findReports(this.xUnitToolInfo, ws, this.xUnitToolInfo.getExpandedPattern());
            if (resultFiles.size() == 0) {
                this.xUnitLog.warning("No test reports found for the metric '" + metricName + "' with the resolved pattern '" + this.xUnitToolInfo.getExpandedPattern() + "'. Configuration error?.");
                return false;
            }
            if (!this.xUnitReportProcessingService.checkIfFindsFilesNewFiles(this.xUnitToolInfo, resultFiles, ws)) {
                return false;
            }
            for (String curFileName : resultFiles) {
                File curFile = this.xUnitReportProcessingService.getCurrentReport(ws, curFileName);
                if (!this.xUnitValidationService.checkFileIsNotEmpty(curFile)) {
                    String msg = "The result file '" + curFile.getPath() + "' for the metric '" + metricName + "' is empty. The result file has been skipped.";
                    this.xUnitLog.warning(msg);
                    return false;
                }
                if (!this.xUnitValidationService.validateInputFile(this.xUnitToolInfo, curFile)) {
                    this.xUnitLog.warning("The result file '" + curFile + "' for the metric '" + metricName + "' is not valid. The result file has been skipped.");
                    return false;
                }
                File junitTargetFile = this.xUnitConversionService.convert(this.xUnitToolInfo, curFile, ws, junitOuputDir);
                if (this.xUnitValidationService.validateOutputFile(this.xUnitToolInfo, curFile, junitTargetFile)) continue;
                this.xUnitLog.warning("The converted file for the result file '" + curFile + "' (during conversion process for the metric '" + metricName + "') is not valid. The report file has been skipped.");
                return false;
            }
        }
        catch (Exception xe) {
            throw new IOException2("There are some problems during the conversion into JUnit reports: " + xe.getMessage(), (Throwable)xe);
        }
        return true;
    }
}

