/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit;

import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitTransformer;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String JUNIT_FILE_PATTERN = "**/TEST-*.xml";
    public TestType[] types;

    public XUnitPublisher(TestType[] types) {
        this.types = types;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    private TestResult getTestResult(AbstractBuild<?, ?> build, File junitFileDir, String junitFilePattern, TestResult existingTestResults, long buildTime, long nowMaster) throws XUnitException {
        try {
            return (TestResult)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException ioe) {
            throw new XUnitException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException((Throwable)ie);
        }
    }

    private void recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, File junitTargetDirectory) throws XUnitException {
        TestResultAction action;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        TestResult existingTestResults = null;
        if (existingAction != null) {
            existingTestResults = existingAction.getResult();
        }
        TestResult result = this.getTestResult(build, junitTargetDirectory, JUNIT_FILE_PATTERN, existingTestResults, buildTime, nowMaster);
        if (existingAction == null) {
            action = new TestResultAction(build, result, listener);
        } else {
            action = existingAction;
            action.setResult(result, listener);
        }
        if (result.getPassCount() == 0 && result.getFailCount() == 0) {
            throw new XUnitException("None of the test reports contained any result");
        }
        if (existingAction == null) {
            build.getActions().add(action);
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        XUnitLog.log((BuildListener)listener, (String)"Starting to record.");
        Result previousResult = build.getResult();
        try {
            boolean resultDeletionOK;
            File junitOuputDir = new File(new FilePath(build.getWorkspace(), "generatedJUnitFiles").toURI());
            if (!junitOuputDir.mkdirs()) {
                XUnitLog.log((BuildListener)listener, (String)("Can't create the path " + junitOuputDir + ". Maybe the directory already exists."));
            }
            XUnitTransformer xUnitTransformer = new XUnitTransformer(listener, junitOuputDir, build.getTimeInMillis(), this.types);
            boolean resultTransformation = (Boolean)build.getWorkspace().act((FilePath.FileCallable)xUnitTransformer);
            if (!resultTransformation) {
                build.setResult(Result.FAILURE);
                XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
                return true;
            }
            this.recordTestResult(build, listener, junitOuputDir);
            TestResultAction testResultAction = (TestResultAction)build.getAction(TestResultAction.class);
            Result curResult = Result.SUCCESS;
            if (testResultAction.getResult().getFailCount() > 0) {
                curResult = Result.UNSTABLE;
            }
            if (!(resultDeletionOK = ((Boolean)build.getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */)).booleanValue())) {
                build.setResult(Result.FAILURE);
                XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
                return true;
            }
            if (previousResult.isWorseOrEqualTo(curResult)) {
                build.setResult(previousResult);
                XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
                return true;
            }
            XUnitLog.log((BuildListener)listener, (String)("Setting the build status to " + curResult));
            build.setResult(curResult);
            XUnitLog.log((BuildListener)listener, (String)"Stopping recording.");
            return true;
        }
        catch (IOException ie) {
            XUnitLog.log((BuildListener)listener, (String)("The plugin hasn't been performed correctly: " + ie.getMessage()));
            build.setResult(Result.FAILURE);
            return false;
        }
        catch (XUnitException xe) {
            XUnitLog.log((BuildListener)listener, (String)("The plugin hasn't been performed correctly: " + xe.getMessage()));
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }
}

