/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.transformer;

import com.thalesgroup.dtkit.metrics.api.InputMetric;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.util.converter.ConvertException;
import com.thalesgroup.dtkit.util.validator.ValidatorError;
import com.thalesgroup.dtkit.util.validator.ValidatorException;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.util.XUnitLog;
import hudson.FilePath;
import hudson.Util;
import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    public static final String JUNIT_FILE_POSTFIX = ".xml";
    public static final String JUNIT_FILE_PREFIX = "TEST-";
    private final BuildListener listener;
    private final File junitOuputDir;
    private final TestType[] types;
    private final long buildTime;

    public XUnitTransformer(BuildListener listener, File junitOuputDir, long buildTime, TestType[] types) {
        this.junitOuputDir = junitOuputDir;
        this.listener = listener;
        this.buildTime = buildTime;
        this.types = types;
    }

    private boolean isEmptyPattern(String pattern) {
        return pattern == null || pattern.trim().length() == 0;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        try {
            boolean isInvoked = false;
            for (TestType tool : this.types) {
                if (this.isEmptyPattern(tool.getPattern())) continue;
                isInvoked = true;
                boolean result = this.processTool(ws, tool);
                if (result) continue;
                return result;
            }
            if (!isInvoked) {
                String msg = "[ERROR] - No test report files were found. Configuration error?";
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return false;
            }
        }
        catch (XUnitException xe) {
            throw new IOException2("Problem on converting into JUnit reports.", (Throwable)xe);
        }
        return true;
    }

    private List<String> findReports(TestType testTool, long buildTime, File parentPath, String pattern, boolean faildedIfNotNew) {
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        File baseDir = ds.getBasedir();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = "[ERROR] - No test report file(s) were found with the pattern '" + pattern + "' relative to '" + parentPath + "' for the testing framework '" + testTool.getDescriptor().getDisplayName() + "'." + "  Did you enter a pattern relative to the correct directory?" + "  Did you generate the result report(s) for '" + testTool.getDescriptor().getDisplayName() + "'?";
            XUnitLog.log((BuildListener)this.listener, (String)msg);
            return null;
        }
        if (faildedIfNotNew) {
            ArrayList<File> oldResults = new ArrayList<File>();
            for (String value : xunitFiles) {
                File reportFile = new File(baseDir, value);
                if (buildTime - 3000L <= reportFile.lastModified()) continue;
                oldResults.add(reportFile);
            }
            if (!oldResults.isEmpty()) {
                long localTime = System.currentTimeMillis();
                if (localTime < buildTime - 1000L) {
                    String msg = "[ERROR] - Clock on this slave is out of sync with the master, and therefore \nI can't figure out what test results are new and what are old.\nPlease keep the slave clock in sync with the master.";
                    XUnitLog.log((BuildListener)this.listener, (String)msg);
                    return null;
                }
                String msg = "[ERROR] Test reports were found but not all of them are new. Did all the tests run?\n";
                for (File f : oldResults) {
                    msg = msg + String.format("  * %s is %s old\n", f, Util.getTimeSpanString((long)(buildTime - f.lastModified())));
                }
                XUnitLog.log((BuildListener)this.listener, (String)msg);
                return null;
            }
        }
        return Arrays.asList(xunitFiles);
    }

    private boolean processTool(File ws, TestType testTool) throws XUnitException {
        try {
            InputMetric inputMetric = testTool.getInputMetric();
            if (inputMetric == null) {
                throw new RuntimeException("The associated input metric object to the tool " + testTool + " is null.");
            }
            String curPattern = testTool.getPattern();
            List resultFiles = this.findReports(testTool, this.buildTime, ws, curPattern = curPattern.replaceAll("[\t\r\n]+", " "), testTool.isFaildedIfNotNew());
            if (resultFiles == null || resultFiles.size() == 0) {
                return false;
            }
            XUnitLog.log((BuildListener)this.listener, (String)("[" + testTool.getDescriptor().getDisplayName() + "] - Processing " + resultFiles.size() + " files with the pattern '" + testTool.getPattern() + "' relative to '" + ws + "'."));
            for (String resultFileName : resultFiles) {
                File resultFile = new File(ws, resultFileName);
                if (resultFile.length() == 0L) {
                    String msg = "[WARNING] - The file '" + resultFile.getPath() + "' is empty. This file has been ignored.";
                    XUnitLog.log((BuildListener)this.listener, (String)msg);
                    continue;
                }
                if (!inputMetric.validateInputFile(resultFile)) {
                    XUnitLog.log((BuildListener)this.listener, (String)("[WARNING] - The file '" + resultFile + "' is an invalid file."));
                    for (ValidatorError validatorError : inputMetric.getInputValidationErrors()) {
                        XUnitLog.log((BuildListener)this.listener, (String)("[WARNING] " + validatorError.toString()));
                    }
                    XUnitLog.log((BuildListener)this.listener, (String)("[WARNING] - The file '" + resultFile + "' has been ignored."));
                    continue;
                }
                File parent = new File(this.junitOuputDir, inputMetric.getToolName());
                parent.mkdirs();
                if (!parent.exists()) {
                    throw new XUnitException("Can't create " + parent);
                }
                File junitTargetFile = new File(parent, JUNIT_FILE_PREFIX + resultFile.hashCode() + JUNIT_FILE_POSTFIX);
                XUnitLog.log((BuildListener)this.listener, (String)("[INFO] - Converting '" + resultFile + "' ."));
                inputMetric.convert(resultFile, junitTargetFile);
                boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
                if (validateOutput) continue;
                XUnitLog.log((BuildListener)this.listener, (String)("[ERROR] - The converted file for the input file '" + resultFile + "' doesn't match the JUnit format"));
                for (ValidatorError validatorError : inputMetric.getOutputValidationErrors()) {
                    XUnitLog.log((BuildListener)this.listener, (String)("[ERROR] " + validatorError.toString()));
                }
                return false;
            }
        }
        catch (ValidatorException vae) {
            throw new XUnitException("Validation failed", (Throwable)vae);
        }
        catch (ConvertException ce) {
            throw new XUnitException("Conversion failed", (Throwable)ce);
        }
        return true;
    }
}

