/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.api.InputMetric;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.util.converter.ConversionException;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import com.thalesgroup.hudson.plugins.xunit.types.CustomInputMetric;
import com.thalesgroup.hudson.plugins.xunit.types.CustomType;
import java.io.File;
import java.io.Serializable;

public class XUnitConversionService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    void set(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    private void prepareConversion(XUnitToolInfo xUnitToolInfo, File workspace) throws XUnitException {
        TestType testType = xUnitToolInfo.getTestType();
        if (testType.getClass() == CustomType.class) {
            String xsl = ((CustomType)testType).getCustomXSL();
            File xslFile = new File(workspace, xsl);
            if (!xslFile.exists()) {
                throw new XUnitException("The input xsl '" + xsl + "' relative to the workspace '" + workspace + "'doesn't exist.");
            }
            xUnitToolInfo.setCusXSLFile(xslFile);
        }
    }

    public File convert(XUnitToolInfo xUnitToolInfo, File inputFile, File workspace, File junitOutputDirectory) throws XUnitException {
        this.prepareConversion(xUnitToolInfo, workspace);
        TestType testType = xUnitToolInfo.getTestType();
        InputMetric inputMetric = testType.getInputMetric();
        String JUNIT_FILE_POSTFIX = ".xml";
        String JUNIT_FILE_PREFIX = "TEST-";
        File parent = new File(junitOutputDirectory, inputMetric.getToolName());
        parent.mkdirs();
        if (!parent.exists()) {
            throw new XUnitException("Can't create " + parent);
        }
        File junitTargetFile = new File(parent, "TEST-" + inputFile.hashCode() + ".xml");
        this.xUnitLog.info("Converting '" + inputFile + "' .");
        try {
            if (testType.getClass() == CustomType.class) {
                ((CustomInputMetric)inputMetric).setCustomXSLFile(xUnitToolInfo.getCusXSLFile());
            }
            inputMetric.convert(inputFile, junitTargetFile);
        }
        catch (ConversionException ce) {
            throw new XUnitException("Conversion error", (Throwable)ce);
        }
        return junitTargetFile;
    }
}

