/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.transformer;

import com.google.inject.Inject;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitConversionService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitReportProcessingService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitValidationService;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
implements FilePath.FileCallable<Boolean>,
Serializable {
    private XUnitReportProcessingService xUnitReportProcessingService;
    private XUnitConversionService xUnitConversionService;
    private XUnitValidationService xUnitValidationService;
    private XUnitToolInfo xUnitToolInfo;
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitReportProcessingService xUnitReportProcessingService, XUnitConversionService xUnitConversionService, XUnitValidationService xUnitValidationService, XUnitToolInfo xUnitToolInfo, XUnitLog xUnitLog) {
        this.xUnitReportProcessingService = xUnitReportProcessingService;
        this.xUnitValidationService = xUnitValidationService;
        this.xUnitConversionService = xUnitConversionService;
        this.xUnitToolInfo = xUnitToolInfo;
        this.xUnitLog = xUnitLog;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        try {
            List resultFiles = this.xUnitReportProcessingService.findReports(this.xUnitToolInfo, ws, this.xUnitToolInfo.getExpandedPattern());
            if (resultFiles.size() == 0) {
                return false;
            }
            if (!this.xUnitReportProcessingService.checkIfFindsFilesNewFiles(this.xUnitToolInfo, resultFiles, ws)) {
                return false;
            }
            for (String curFileName : resultFiles) {
                File curFile = this.xUnitReportProcessingService.getCurrentReport(ws, curFileName);
                if (!this.xUnitValidationService.checkFileIsNotEmpty(curFile)) {
                    String msg = "The file '" + curFile.getPath() + "' is empty. This file has been ignored.";
                    this.xUnitLog.warning(msg);
                    return false;
                }
                if (!this.xUnitValidationService.validateInputFile(this.xUnitToolInfo, curFile)) {
                    this.xUnitLog.warning("The file '" + curFile + "' has been ignored.");
                    return false;
                }
                File junitTargetFile = this.xUnitConversionService.convert(this.xUnitToolInfo, curFile, ws, this.xUnitToolInfo.getJunitOutputDir());
                boolean result = this.xUnitValidationService.validateOutputFile(this.xUnitToolInfo, curFile, junitTargetFile);
                if (result) continue;
                return false;
            }
        }
        catch (XUnitException xe) {
            throw new IOException2("There are some problems during the conversion into JUnit reports: " + xe.getMessage(), (Throwable)xe);
        }
        return true;
    }
}

