/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.dtkit.util.validator.ValidationError;
import com.thalesgroup.dtkit.util.validator.ValidationException;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.transformer.XUnitToolInfo;
import java.io.File;
import java.io.Serializable;

public class XUnitValidationService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    void set(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean checkFileIsNotEmpty(File inputFile) {
        return inputFile.length() != 0L;
    }

    public boolean validateInputFile(XUnitToolInfo xUnitToolInfo, File inputFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getTestType().getInputMetric();
        try {
            if (!inputMetric.validateInputFile(inputFile)) {
                this.xUnitLog.warning("The file '" + inputFile + "' is an invalid file.");
                for (ValidationError validatorError : inputMetric.getInputValidationErrors()) {
                    this.xUnitLog.warning(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on input", (Throwable)ve);
        }
        return true;
    }

    public boolean validateOutputFile(XUnitToolInfo xUnitToolInfo, File inputFile, File junitTargetFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getTestType().getInputMetric();
        try {
            boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
            if (!validateOutput) {
                this.xUnitLog.error("The converted file for the input file '" + inputFile + "' doesn't match the JUnit format");
                for (ValidationError validatorError : inputMetric.getOutputValidationErrors()) {
                    this.xUnitLog.error(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on output", (Throwable)ve);
        }
        return true;
    }
}

