/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.xvnc.DisplayAllocator;
import hudson.plugins.xvnc.Xvnc;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xvnc
extends BuildWrapper {
    private static final DisplayAllocator allocator = new DisplayAllocator();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String vncserverCommand;
        PrintStream logger = listener.getLogger();
        String cmd = Util.nullify((String)Xvnc.DESCRIPTOR.xvnc);
        int baseDisplayNumber = Xvnc.DESCRIPTOR.baseDisplayNumber;
        if (cmd == null) {
            cmd = "vncserver :$DISPLAY_NUMBER";
        }
        int displayNumber = allocator.allocate(baseDisplayNumber);
        String actualCmd = Util.replaceMacro((String)cmd, Collections.singletonMap("DISPLAY_NUMBER", String.valueOf(displayNumber)));
        logger.println("Starting xvnc");
        Proc proc = launcher.launch(actualCmd, new String[0], (OutputStream)logger, build.getProject().getWorkspace());
        Matcher m = Pattern.compile("([^ ]*vncserver ).*:\\d+.*").matcher(actualCmd);
        if (m.matches()) {
            vncserverCommand = m.group(1);
            int exit = proc.join();
            if (exit != 0) {
                throw new IOException("Failed to run '" + actualCmd + "' (exit code " + exit + "), blacklisting display #" + displayNumber + "; consider adding to your Hudson launch script: killall Xvnc; rm -fv /tmp/.X*-lock /tmp/.X11-unix/X*");
            }
        } else {
            vncserverCommand = null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ DisplayAllocator access$000() {
        return allocator;
    }
}

