/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.plugins.xvnc.DisplayAllocator;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xvnc
extends BuildWrapper {
    public boolean takeScreenshot;
    private static final String FILENAME_SCREENSHOT = "screenshot.jpg";
    private static final DisplayAllocator allocator = new DisplayAllocator();
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    public BuildWrapper.Environment setUp(AbstractBuild build, final Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String vncserverCommand;
        final PrintStream logger = listener.getLogger();
        String cmd = Util.nullify((String)Xvnc.DESCRIPTOR.xvnc);
        int baseDisplayNumber = Xvnc.DESCRIPTOR.baseDisplayNumber;
        if (cmd == null) {
            cmd = "vncserver :$DISPLAY_NUMBER";
        }
        final int displayNumber = allocator.allocate(baseDisplayNumber);
        String actualCmd = Util.replaceMacro((String)cmd, Collections.singletonMap("DISPLAY_NUMBER", String.valueOf(displayNumber)));
        logger.println("Starting xvnc");
        final Proc proc = launcher.launch(actualCmd, new String[0], (OutputStream)logger, build.getProject().getWorkspace());
        Matcher m = Pattern.compile("([^ ]*vncserver ).*:\\d+.*").matcher(actualCmd);
        if (m.matches()) {
            vncserverCommand = m.group(1);
            int exit = proc.join();
            if (exit != 0) {
                throw new IOException("Failed to run '" + actualCmd + "' (exit code " + exit + "), blacklisting display #" + displayNumber + "; consider adding to your Hudson launch script: killall Xvnc; rm -fv /tmp/.X*-lock /tmp/.X11-unix/X*");
            }
        } else {
            vncserverCommand = null;
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("DISPLAY", ":" + displayNumber);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                logger.println("Terminating xvnc");
                if (vncserverCommand != null) {
                    if (Xvnc.this.takeScreenshot) {
                        FilePath ws = build.getProject().getWorkspace();
                        File artifactsDir = build.getArtifactsDir();
                        artifactsDir.mkdirs();
                        logger.println("Taking screenshot.");
                        launcher.launch("import -window root -display :" + displayNumber + " " + Xvnc.FILENAME_SCREENSHOT, new String[0], (OutputStream)logger, ws).join();
                        ws.child(Xvnc.FILENAME_SCREENSHOT).copyTo(new FilePath(artifactsDir).child(Xvnc.FILENAME_SCREENSHOT));
                    }
                    launcher.launch(vncserverCommand + "-kill :" + displayNumber, new String[0], (OutputStream)logger, build.getProject().getWorkspace()).join();
                } else {
                    proc.kill();
                }
                allocator.free(displayNumber);
                return true;
            }
        };
    }

    public Descriptor<BuildWrapper> getDescriptor() {
        return DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String xvnc;
        public int baseDisplayNumber = 10;

        DescriptorImpl() {
            super(Xvnc.class);
            this.load();
        }

        public String getDisplayName() {
            return "Run Xvnc during build";
        }

        public boolean configure(StaplerRequest req) throws Descriptor.FormException {
            req.bindParameters((Object)this, "xvnc.");
            this.save();
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xvnc/help-projectConfig.html";
        }

        public Xvnc newInstance(StaplerRequest req) throws Descriptor.FormException {
            Xvnc x = new Xvnc();
            req.bindParameters((Object)x, "xvnc.");
            return x;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

