/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.plugins.xvnc.DisplayAllocator;
import hudson.plugins.xvnc.Messages;
import hudson.plugins.xvnc.Xvnc;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;

public class Xvnc
extends BuildWrapper {
    public boolean takeScreenshot;
    private static final String FILENAME_SCREENSHOT = "screenshot.jpg";
    private static final DisplayAllocator allocator = new DisplayAllocator();

    @DataBoundConstructor
    public Xvnc(boolean takeScreenshot) {
        this.takeScreenshot = takeScreenshot;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String vncserverCommand;
        PrintStream logger = listener.getLogger();
        DescriptorImpl DESCRIPTOR = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        String cmd = Util.nullify((String)DESCRIPTOR.xvnc);
        int baseDisplayNumber = DESCRIPTOR.baseDisplayNumber;
        if (cmd == null) {
            cmd = "vncserver :$DISPLAY_NUMBER";
        }
        int displayNumber = allocator.allocate(baseDisplayNumber);
        String actualCmd = Util.replaceMacro((String)cmd, Collections.singletonMap("DISPLAY_NUMBER", String.valueOf(displayNumber)));
        logger.println(Messages.Xvnc_STARTING());
        Proc proc = launcher.launch(actualCmd, new String[0], (OutputStream)logger, build.getProject().getWorkspace());
        Matcher m = Pattern.compile("([^ ]*vncserver ).*:\\d+.*").matcher(actualCmd);
        if (m.matches()) {
            vncserverCommand = m.group(1);
            int exit = proc.join();
            if (exit != 0) {
                throw new IOException("Failed to run '" + actualCmd + "' (exit code " + exit + "), blacklisting display #" + displayNumber + "; consider adding to your Hudson launch script: killall Xvnc Xrealvnc; rm -fv /tmp/.X*-lock /tmp/.X11-unix/X*");
            }
        } else {
            vncserverCommand = null;
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ DisplayAllocator access$000() {
        return allocator;
    }
}

