/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.xvnc;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Label;
import hudson.plugins.xvnc.DisplayAllocator;
import hudson.plugins.xvnc.Messages;
import hudson.plugins.xvnc.NodePropertyImpl;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class Xvnc
extends BuildWrapper {
    public boolean takeScreenshot;
    private static final String FILENAME_SCREENSHOT = "screenshot.jpg";
    private static final DisplayAllocator allocator = new DisplayAllocator();

    @DataBoundConstructor
    public Xvnc(boolean takeScreenshot) {
        this.takeScreenshot = takeScreenshot;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        DescriptorImpl DESCRIPTOR = (DescriptorImpl)Hudson.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (build.getBuiltOn().getAssignedLabels().contains(Label.get((String)"noxvnc")) || build.getBuiltOn().getNodeProperties().get(NodePropertyImpl.class) != null) {
            return new BuildWrapper.Environment(){};
        }
        if (DESCRIPTOR.skipOnWindows && !launcher.isUnix()) {
            return new BuildWrapper.Environment(){};
        }
        String cmd = Util.nullify((String)DESCRIPTOR.xvnc);
        int baseDisplayNumber = DESCRIPTOR.baseDisplayNumber;
        if (cmd == null) {
            cmd = "vncserver :$DISPLAY_NUMBER";
        }
        return this.doSetUp(build, launcher, logger, cmd, baseDisplayNumber, 3);
    }

    private BuildWrapper.Environment doSetUp(AbstractBuild build, final Launcher launcher, final PrintStream logger, String cmd, int baseDisplayNumber, int retries) throws IOException, InterruptedException {
        String vncserverCommand;
        final int displayNumber = allocator.allocate(baseDisplayNumber);
        String actualCmd = Util.replaceMacro((String)cmd, Collections.singletonMap("DISPLAY_NUMBER", String.valueOf(displayNumber)));
        logger.println(Messages.Xvnc_STARTING());
        String[] cmds = Util.tokenize((String)actualCmd);
        final Proc proc = launcher.launch().cmds(cmds).stdout((OutputStream)logger).pwd(build.getWorkspace()).start();
        if (cmds[0].endsWith("vncserver") && cmd.contains(":$DISPLAY_NUMBER")) {
            vncserverCommand = cmds[0];
            int exit = proc.join();
            if (exit != 0) {
                String message = "Failed to run '" + actualCmd + "' (exit code " + exit + "), blacklisting display #" + displayNumber + "; consider adding to your Hudson launch script: killall Xvnc Xrealvnc; rm -fv /tmp/.X*-lock /tmp/.X11-unix/X*";
                if (retries > 0) {
                    return this.doSetUp(build, launcher, logger, cmd, baseDisplayNumber, retries - 1);
                }
                throw new IOException(message);
            }
        } else {
            vncserverCommand = null;
        }
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put("DISPLAY", ":" + displayNumber);
            }

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (Xvnc.this.takeScreenshot) {
                    FilePath ws = build.getWorkspace();
                    File artifactsDir = build.getArtifactsDir();
                    artifactsDir.mkdirs();
                    logger.println(Messages.Xvnc_TAKING_SCREENSHOT());
                    launcher.launch().cmds(new String[]{"import", "-window", "root", "-display", ":" + displayNumber, Xvnc.FILENAME_SCREENSHOT}).stdout((OutputStream)logger).pwd(ws).join();
                    ws.child(Xvnc.FILENAME_SCREENSHOT).copyTo(new FilePath(artifactsDir).child(Xvnc.FILENAME_SCREENSHOT));
                }
                logger.println(Messages.Xvnc_TERMINATING());
                if (vncserverCommand != null) {
                    launcher.launch().cmds(new String[]{vncserverCommand, "-kill", ":" + displayNumber}).stdout((OutputStream)logger).pwd(build.getWorkspace()).join();
                } else {
                    proc.kill();
                }
                allocator.free(displayNumber);
                return true;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String xvnc;
        public int baseDisplayNumber = 10;
        public boolean skipOnWindows = true;

        public DescriptorImpl() {
            super(Xvnc.class);
            this.load();
        }

        public String getDisplayName() {
            return "Run Xvnc during build";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return true;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getCommandline() {
            return this.xvnc;
        }

        public void setCommandline(String value) {
            this.xvnc = value;
        }

        public FormValidation doCheckCommandline(@QueryParameter String value) {
            if (Util.nullify((String)value) == null || value.contains("$DISPLAY_NUMBER")) {
                return FormValidation.ok();
            }
            return FormValidation.warningWithMarkup((String)Messages.Xvnc_SHOULD_INCLUDE_DISPLAY_NUMBER());
        }
    }
}

