/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.proxy_dhcp;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.proxy_dhcp.DHCPMessageType;
import org.jvnet.hudson.proxy_dhcp.DHCPOption;
import org.jvnet.hudson.proxy_dhcp.DHCPPacket;
import org.jvnet.hudson.proxy_dhcp.PXEOptions;

public class ProxyDhcpService
implements Runnable,
Closeable {
    public final Inet4Address tftpServer;
    public final String bootFileName;
    private final DatagramSocket server;
    private static final int DHCP_CLIENT_PORT = 68;
    private static final int DHCP_SERVER_PORT = 67;
    private static final Logger LOGGER = Logger.getLogger(ProxyDhcpService.class.getName());

    public ProxyDhcpService(Inet4Address tftpServer, String bootFileName) throws SocketException {
        this(tftpServer, bootFileName, null);
    }

    public ProxyDhcpService(Inet4Address tftpServer, String bootFileName, InetAddress interfaceToListen) throws SocketException {
        this.tftpServer = tftpServer;
        this.bootFileName = bootFileName;
        this.server = new DatagramSocket(67, interfaceToListen);
        this.server.setBroadcast(true);
        LOGGER.info("TFTP server: " + tftpServer.getHostAddress());
        LOGGER.info("Boot file: " + bootFileName);
    }

    public void run() {
        try {
            this.execute();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "IO exception in proxy DHCP service", e);
        }
    }

    public void execute() throws IOException {
        DatagramPacket datagram = new DatagramPacket(new byte[8192], 8192);
        while (true) {
            this.server.receive(datagram);
            LOGGER.fine("Got a packet from " + datagram.getSocketAddress());
            try {
                this.handle(this.server, datagram);
                continue;
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "Failed to handle a DHCP packet", e);
                continue;
            }
            break;
        }
    }

    public void close() {
        this.server.close();
    }

    private void handle(DatagramSocket server, DatagramPacket datagram) throws IOException {
        DHCPPacket packet = new DHCPPacket(datagram);
        if (packet.op != 1) {
            LOGGER.fine("Not a BOOT request: " + packet.op);
            return;
        }
        if (!packet.is(DHCPMessageType.DHCPDISCOVER)) {
            LOGGER.fine("Not a DHCPDISCOVER");
            return;
        }
        String vendorClass = packet.getVendorClassIdentifier();
        if (vendorClass == null || !vendorClass.startsWith("PXEClient")) {
            LOGGER.fine("Not a PXEClient: " + vendorClass);
            return;
        }
        DHCPPacket reply = packet.createResponse();
        reply.siaddr = this.tftpServer;
        reply.chaddr = packet.chaddr;
        reply.file = this.bootFileName;
        reply.options.add(DHCPMessageType.DHCPOFFER.createOption());
        reply.options.add(new DHCPOption(54, this.tftpServer));
        reply.options.add(DHCPOption.createVendorClassIdentifier("PXEClient"));
        reply.options.add(PXEOptions.createDiscoveryControl());
        datagram = reply.pack();
        datagram.setAddress(InetAddress.getByName("255.255.255.255"));
        datagram.setPort(68);
        server.send(datagram);
        LOGGER.fine("responded");
    }

    public static void main(String[] args) throws IOException {
        LOGGER.setLevel(Level.ALL);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        LOGGER.addHandler(h);
        LOGGER.setUseParentHandlers(false);
        new ProxyDhcpService((Inet4Address)InetAddress.getByName(args[0]), args[1]).run();
    }
}

