/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.proxy_dhcp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import org.jvnet.hudson.pxeboot.DataInputStream2;
import org.jvnet.hudson.pxeboot.DataOutputStream2;

public class DHCPOption {
    public byte tag;
    public byte[] data;
    public static final byte OPTION_PAD = 0;
    public static final byte OPTION_END = -1;
    public static final byte OPTION_DHCP_MESSAGE_TYPE = 53;
    public static final byte OPTION_DHCP_SERVER_IDENTIFIER = 54;
    public static final byte OPTION_VENDOR_CLASS_IDENTIFIER = 60;
    public static final byte OPTION_VENDOR_ENCAPSULATED_OPTIONS = 43;

    public DHCPOption() {
    }

    public DHCPOption(byte tag, byte[] data) {
        this.tag = tag;
        this.data = data;
    }

    public DHCPOption(byte tag, Inet4Address adrs) {
        this(tag, adrs.getAddress());
    }

    DHCPOption(DataInputStream2 di) throws IOException {
        this.tag = di.readByte();
        if (this.tag == -1 || this.tag == 0) {
            return;
        }
        byte len = di.readByte();
        this.data = di.readByteArray(DHCPOption.uint(len));
    }

    private static int uint(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }

    void writeTo(DataOutputStream2 o) throws IOException {
        o.writeByte(this.tag);
        o.writeByte(this.data.length);
        o.write(this.data);
    }

    public String getDataAsString() {
        try {
            int i;
            for (i = 0; i < this.data.length && this.data[i] != 0; ++i) {
            }
            return new String(this.data, 0, i, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isEnd() {
        return this.tag == -1;
    }

    public boolean isPad() {
        return this.tag == 0;
    }

    public static DHCPOption createVendorClassIdentifier(String c) {
        byte[] bytes = c.getBytes();
        byte[] bytesPlusOne = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, bytesPlusOne, 0, bytes.length);
        return new DHCPOption(60, bytesPlusOne);
    }
}

