/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.proxy_dhcp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jvnet.hudson.proxy_dhcp.DHCPMessageType;
import org.jvnet.hudson.proxy_dhcp.DHCPOption;
import org.jvnet.hudson.pxeboot.DataInputStream2;
import org.jvnet.hudson.pxeboot.DataOutputStream2;

public class DHCPPacket {
    public byte op;
    public byte htype;
    public byte hlen;
    public byte hops;
    public int xid;
    public short secs;
    public short flags;
    public Inet4Address ciaddr;
    public Inet4Address yiaddr;
    public Inet4Address siaddr;
    public Inet4Address giaddr;
    public byte[] chaddr;
    public String sname;
    public String file;
    public List<DHCPOption> options = new ArrayList<DHCPOption>();
    private static final byte[] OPTIONS_COOKIE = new byte[]{99, -126, 83, 99};
    public static final byte OP_BOOTREQUEST = 1;
    public static final byte OP_BOOTREPLY = 2;

    public DHCPPacket() {
    }

    public DHCPPacket(DatagramPacket p) throws IOException {
        DataInputStream2 di = new DataInputStream2(p);
        this.op = di.readByte();
        this.htype = di.readByte();
        this.hlen = di.readByte();
        this.hops = di.readByte();
        this.xid = di.readInt();
        this.secs = di.readShort();
        this.flags = di.readShort();
        this.ciaddr = di.readInet4Address();
        this.yiaddr = di.readInet4Address();
        this.siaddr = di.readInet4Address();
        this.giaddr = di.readInet4Address();
        this.chaddr = new byte[16];
        di.readFully(this.chaddr);
        this.sname = di.readFixedLengthNullTerminatedString(64);
        this.file = di.readFixedLengthNullTerminatedString(128);
        byte[] magic = di.readByteArray(4);
        if (!Arrays.equals(magic, OPTIONS_COOKIE)) {
            throw new IllegalArgumentException("Not a valid DHCP packet: incorrect magic value");
        }
        while (di.available() > 0) {
            DHCPOption opt = new DHCPOption(di);
            if (opt.isEnd()) {
                return;
            }
            this.options.add(opt);
        }
    }

    public DHCPOption getOption(byte tag) {
        for (DHCPOption option : this.options) {
            if (option.tag != tag) continue;
            return option;
        }
        return null;
    }

    public boolean is(DHCPMessageType type) {
        DHCPOption o = this.getOption((byte)53);
        return o != null && type.code == o.data[0];
    }

    public String getVendorClassIdentifier() {
        DHCPOption o = this.getOption((byte)60);
        if (o == null) {
            return null;
        }
        return o.getDataAsString();
    }

    public DHCPPacket createResponse() {
        DHCPPacket that = new DHCPPacket();
        that.op = (byte)2;
        that.htype = this.htype;
        that.hlen = this.hlen;
        that.xid = this.xid;
        that.flags = this.flags;
        return that;
    }

    public DatagramPacket pack() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream2 o = new DataOutputStream2(baos);
        o.writeByte(this.op);
        o.writeByte(this.htype);
        o.writeByte(this.hlen);
        o.writeByte(this.hops);
        o.writeInt(this.xid);
        o.writeShort(this.secs);
        o.writeShort(this.flags);
        o.writeAddress(this.ciaddr);
        o.writeAddress(this.yiaddr);
        o.writeAddress(this.siaddr);
        o.writeAddress(this.giaddr);
        o.write(this.chaddr);
        o.writeFixedLengthNullTerminatedString(this.sname, 64);
        o.writeFixedLengthNullTerminatedString(this.file, 128);
        o.write(OPTIONS_COOKIE);
        for (DHCPOption opt : this.options) {
            opt.writeTo(o);
        }
        o.writeByte(-1);
        byte[] buf = baos.toByteArray();
        return new DatagramPacket(buf, buf.length);
    }
}

