/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tftpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class Data {
    public abstract InputStream read() throws IOException;

    public int size() throws IOException {
        int chunk;
        InputStream in = this.read();
        byte[] buf = new byte[4096];
        int size = 0;
        while ((chunk = in.read(buf)) >= 0) {
            size += chunk;
        }
        return size;
    }

    public static Data from(final URL url) {
        return new Data(){

            public InputStream read() throws IOException {
                return url.openStream();
            }

            public int size() throws IOException {
                int len = url.openConnection().getContentLength();
                if (len >= 0) {
                    return len;
                }
                return super.size();
            }
        };
    }

    public static Data from(String data) {
        return Data.from(data.getBytes());
    }

    public static Data from(final byte[] data) {
        return new Data(){

            public InputStream read() {
                return new ByteArrayInputStream(data);
            }

            public int size() {
                return data.length;
            }
        };
    }
}

