/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tftpd.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Map;
import java.util.TreeMap;
import org.jvnet.hudson.tftpd.impl.TFTPPacket;
import org.jvnet.hudson.tftpd.impl.TFTPPacketException;

public class TFTPOAckPacket
extends TFTPPacket {
    public final Map<String, String> options = new TreeMap<String, String>();

    public TFTPOAckPacket(InetAddress destination, int port) {
        super(6, destination, port);
    }

    TFTPOAckPacket(DatagramPacket datagram) throws IOException {
        super(6, datagram.getAddress(), datagram.getPort());
        byte[] data = datagram.getData();
        DataInputStream di = new DataInputStream(new ByteArrayInputStream(data));
        if (this.getType() != di.readShort()) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        while (di.available() > 0) {
            this.options.put(this.readString(di), this.readString(di));
        }
    }

    private String readString(DataInput di) throws IOException {
        byte ch;
        StringBuilder buf = new StringBuilder();
        while ((ch = di.readByte()) != 0) {
            buf.append((char)ch);
        }
        return buf.toString();
    }

    DatagramPacket _newDatagram(DatagramPacket datagram, byte[] data) {
        throw new UnsupportedOperationException();
    }

    public DatagramPacket newDatagram() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this._type);
            for (Map.Entry<String, String> e : this.options.entrySet()) {
                dos.write(e.getKey().getBytes());
                dos.write(0);
                dos.write(e.getValue().getBytes());
                dos.write(0);
            }
            byte[] data = baos.toByteArray();
            return new DatagramPacket(data, data.length, this._address, this._port);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

