/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tftpd.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jvnet.hudson.pxeboot.DataInputStream2;
import org.jvnet.hudson.tftpd.impl.TFTPPacket;
import org.jvnet.hudson.tftpd.impl.TFTPPacketException;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] _modeStrings = new String[]{"netascii", "octet"};
    static final byte[][] _modeBytes = new byte[][]{{110, 101, 116, 97, 115, 99, 105, 105, 0}, {111, 99, 116, 101, 116, 0}};
    int _mode;
    String _filename;
    public final Map<String, String> options = new LinkedHashMap<String, String>();

    TFTPRequestPacket(InetAddress destination, int port, int type, String filename, int mode) {
        super(type, destination, port);
        this._filename = filename;
        this._mode = mode;
    }

    TFTPRequestPacket(int type, DatagramPacket datagram) throws IOException {
        super(type, datagram.getAddress(), datagram.getPort());
        DataInputStream2 in = new DataInputStream2(datagram);
        if (this.getType() != in.readShort()) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this._filename = in.readNullTerminatedString();
        String mode = in.readNullTerminatedString().toLowerCase(Locale.ENGLISH);
        this._mode = -1;
        for (int index = 0; index < _modeStrings.length; ++index) {
            if (!mode.equals(_modeStrings[index])) continue;
            this._mode = index;
            break;
        }
        if (this._mode == -1) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + mode);
        }
        while (in.available() > 0) {
            this.options.put(in.readNullTerminatedString(), in.readNullTerminatedString());
        }
    }

    final DatagramPacket _newDatagram(DatagramPacket datagram, byte[] data) {
        int fileLength = this._filename.length();
        int modeLength = _modeBytes[this._mode].length;
        data[0] = 0;
        data[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, data, fileLength + 3, modeLength);
        datagram.setAddress(this._address);
        datagram.setPort(this._port);
        datagram.setData(data);
        datagram.setLength(fileLength + modeLength + 3);
        return datagram;
    }

    public final DatagramPacket newDatagram() {
        int fileLength = this._filename.length();
        int modeLength = _modeBytes[this._mode].length;
        byte[] data = new byte[fileLength + modeLength + 4];
        data[0] = 0;
        data[1] = (byte)this._type;
        System.arraycopy(this._filename.getBytes(), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(_modeBytes[this._mode], 0, data, fileLength + 3, modeLength);
        return new DatagramPacket(data, data.length, this._address, this._port);
    }

    public final int getMode() {
        return this._mode;
    }

    public final String getFilename() {
        return this._filename;
    }
}

