/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tftpd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.tftpd.Data;
import org.jvnet.hudson.tftpd.PathResolver;
import org.jvnet.hudson.tftpd.impl.TFTP;
import org.jvnet.hudson.tftpd.impl.TFTPAckPacket;
import org.jvnet.hudson.tftpd.impl.TFTPDataPacket;
import org.jvnet.hudson.tftpd.impl.TFTPErrorPacket;
import org.jvnet.hudson.tftpd.impl.TFTPOAckPacket;
import org.jvnet.hudson.tftpd.impl.TFTPPacket;
import org.jvnet.hudson.tftpd.impl.TFTPPacketException;
import org.jvnet.hudson.tftpd.impl.TFTPReadRequestPacket;

public class TFTPServer
implements Runnable {
    private final PathResolver resolver;
    private final TFTP tftp = new TFTP();
    private static final int TFTP_PORT = 69;
    private static final Logger LOGGER = Logger.getLogger(TFTPServer.class.getName());

    public TFTPServer(PathResolver resolver) {
        this.resolver = resolver;
        this.tftp.setDefaultTimeout(0);
    }

    public void run() {
        try {
            this.execute();
        }
        catch (IOException e) {
            if ("Socket closed".equals(e.getMessage())) {
                LOGGER.fine("TFTP accept thread closed");
            }
            LOGGER.log(Level.INFO, "IOException in the TFTP accept thread", e);
        }
    }

    public void execute() throws IOException {
        this.tftp.open(69);
        LOGGER.fine("TFTP server ready for action");
        try {
            while (true) {
                try {
                    while (true) {
                        TFTPPacket p;
                        if ((p = this.tftp.receive()) instanceof TFTPReadRequestPacket) {
                            TFTPReadRequestPacket rp = (TFTPReadRequestPacket)p;
                            LOGGER.fine("Starting a new session to transfer " + rp.getFilename());
                            new TFTPSession(rp);
                            continue;
                        }
                        LOGGER.fine("Unexpected packet " + p);
                    }
                }
                catch (TFTPPacketException e) {
                    LOGGER.log(Level.FINE, "Invalid packet received", e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
    }

    public synchronized void close() {
        if (this.tftp.isOpen()) {
            this.tftp.close();
        }
    }

    public static void main(String[] args) throws IOException {
        LOGGER.setLevel(Level.ALL);
        LOGGER.setUseParentHandlers(false);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        LOGGER.addHandler(h);
        TFTPServer server = new TFTPServer(new PathResolver(){

            public Data open(final String fileName) throws IOException {
                return new Data(){

                    public InputStream read() throws IOException {
                        return new FileInputStream(fileName);
                    }

                    public int size() {
                        return (int)new File(fileName).length();
                    }
                };
            }
        });
        new Thread(server).start();
        new BufferedReader(new InputStreamReader(System.in)).readLine();
        server.close();
    }

    final class TFTPSession
    extends TFTP
    implements Runnable {
        private final String fileName;
        private Data data;
        private InputStream stream;
        private final InetSocketAddress dest;
        private final TFTPReadRequestPacket session;
        private int blockSize = 512;

        TFTPSession(TFTPReadRequestPacket rp) throws IOException {
            this.open();
            this.session = rp;
            this.fileName = rp.getFilename();
            this.dest = new InetSocketAddress(rp.getAddress(), rp.getPort());
            try {
                this.data = TFTPServer.this.resolver.open(this.fileName);
                if (this.data == null) {
                    this.sendError(1, "no such file exists: " + this.fileName);
                } else {
                    this.stream = this.data.read();
                    if (this.stream == null) {
                        this.sendError(1, "no such file exists: " + this.fileName);
                    } else {
                        new Thread(this).start();
                    }
                }
            }
            catch (IOException e) {
                this.sendError(1, "failed to read " + this.fileName + " : " + e.getMessage());
                LOGGER.log(Level.INFO, "Failed to read " + this.fileName, e);
            }
        }

        private void sendError(int errorCode, String msg) throws IOException {
            LOGGER.info("Error: " + msg + " -> " + this.dest);
            this.send(new TFTPErrorPacket(this.dest.getAddress(), this.dest.getPort(), errorCode, msg));
        }

        private TFTPDataPacket readNextBlock(int blockNumber) throws IOException {
            int chunk;
            byte[] buf = new byte[this.blockSize];
            int read = 0;
            while ((chunk = this.stream.read(buf, read, buf.length - read)) > 0) {
                read += chunk;
            }
            return new TFTPDataPacket(this.dest.getAddress(), this.dest.getPort(), blockNumber, buf, 0, read);
        }

        private void sendAndWait(TFTPPacket p, int expected) throws IOException {
            int retry = 0;
            while (true) {
                this.send(p);
                try {
                    if (!this.waitAck(expected)) continue;
                    return;
                }
                catch (SocketTimeoutException e) {
                    if (retry++ > 5) {
                        throw e;
                    }
                    LOGGER.fine("Retransmitting " + p);
                    continue;
                }
                break;
            }
        }

        private boolean waitAck(int expected) throws IOException {
            TFTPPacket p = this.receive();
            if (!(p instanceof TFTPAckPacket)) {
                if (p instanceof TFTPErrorPacket) {
                    TFTPErrorPacket ep = (TFTPErrorPacket)p;
                    LOGGER.info("Expecting ACK=" + expected + " but got " + p + " :" + ep.getError() + ":" + ep.getMessage());
                } else {
                    LOGGER.info("Expecting ACK=" + expected + " but got " + p);
                    this.sendError(1, "");
                }
                throw new IOException("Aborting");
            }
            TFTPAckPacket ack = (TFTPAckPacket)p;
            if (ack.getBlockNumber() != expected) {
                LOGGER.info("Expecting ACK=" + expected + " but got ACK for " + ack.getBlockNumber() + " instead. Retransmitting");
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                boolean hasTsize = this.session.options.containsKey("tsize");
                boolean hasBlksize = this.session.options.containsKey("blksize");
                if (hasTsize || hasBlksize) {
                    LOGGER.fine("Got options " + this.session.options);
                    TFTPOAckPacket oack = new TFTPOAckPacket(this.dest.getAddress(), this.dest.getPort());
                    if (hasTsize) {
                        oack.options.put("tsize", String.valueOf(this.data.size()));
                    }
                    if (hasBlksize) {
                        this.blockSize = Integer.parseInt((String)this.session.options.get("blksize"));
                        oack.options.put("blksize", String.valueOf(this.blockSize));
                    }
                    this.sendAndWait(oack, 0);
                }
                int blockNumber = 1;
                while (true) {
                    TFTPDataPacket dp = this.readNextBlock(blockNumber);
                    LOGGER.fine("Sending block #" + blockNumber + " (" + dp.getDataLength() + ")");
                    this.sendAndWait(dp, blockNumber);
                    if (dp.getDataLength() < this.blockSize) {
                        LOGGER.fine("Transmission complete");
                        return;
                    }
                    ++blockNumber;
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.INFO, "IO exception in TFTP session", e);
                return;
            }
            finally {
                LOGGER.fine("Closing a session");
                this.close();
                try {
                    if (this.stream != null) {
                        this.stream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Failed to close " + this.data, e);
                }
            }
        }
    }
}

