/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hpi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;
import org.jvnet.hudson.maven.plugins.hpi.AbstractHpiMojo;

public class HplMojo
extends AbstractHpiMojo {
    private File hudsonHome;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.hudsonHome == null) {
            throw new MojoExecutionException("Property hudsonHome needs to be set to $HUDSON_HOME. Please use 'mvn -DhudsonHome=...' orput <settings><profiles><profile><properties><property><hudsonHome>...</...>");
        }
        if (!this.project.getPackaging().equals("hpi")) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getName() + " because it's not <packaging>hpi</packaging>"));
            return;
        }
        File hplFile = new File(this.hudsonHome, "plugins/" + this.project.getBuild().getFinalName() + ".hpl");
        this.getLog().info((CharSequence)("Generating " + hplFile));
        PrintWriter printWriter = null;
        try {
            Manifest mf = new Manifest();
            Manifest.Section mainSection = mf.getMainSection();
            this.setAttributes(mainSection);
            StringBuffer buf = new StringBuffer();
            buf.append(new File(this.project.getBuild().getOutputDirectory()).getAbsoluteFile());
            for (Artifact a : this.project.getArtifacts()) {
                buf.append(',').append(a.getFile());
            }
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Libraries", buf.toString()));
            mainSection.addAttributeAndCheck(new Manifest.Attribute("Resource-Path", this.warSourceDirectory.getAbsolutePath()));
            printWriter = new PrintWriter(new FileWriter(hplFile));
            mf.write(printWriter);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
    }
}

