/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hpi;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.StringUtils;
import org.jvnet.hudson.maven.plugins.hpi.PropertyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHpiMojo
extends AbstractMojo {
    protected String outputDirectory;
    protected MavenProject project;
    private File classesDirectory;
    protected String pluginName;
    private File webappDirectory;
    protected File warSourceDirectory;
    private Resource[] webResources;
    private List<String> filters;
    private File containerConfigXML;
    private File workDirectory;
    protected ArchiverManager archiverManager;
    private static final String WEB_INF = "WEB-INF";
    private static final String META_INF = "META-INF";
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    private String warSourceIncludes = "**";
    private String warSourceExcludes;
    private String dependentWarIncludes = "**";
    private String dependentWarExcludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public File getContainerConfigXML() {
        return this.containerConfigXML;
    }

    public void setContainerConfigXML(File containerConfigXML) {
        this.containerConfigXML = containerConfigXML;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
            excludeList.add("**/META-INF/" + this.containerConfigXML.getName());
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        String[] excludes = StringUtils.isNotEmpty((String)this.dependentWarExcludes) ? StringUtils.split((String)this.dependentWarExcludes, (String)",") : EMPTY_STRING_ARRAY;
        return excludes;
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        webappDirectory.mkdirs();
        File webinfDir = new File(webappDirectory, WEB_INF);
        webinfDir.mkdirs();
        File metainfDir = new File(webappDirectory, META_INF);
        metainfDir.mkdirs();
        try {
            List<Resource> webResources;
            List<Resource> list = webResources = this.webResources != null ? Arrays.asList(this.webResources) : null;
            if (webResources != null && webResources.size() > 0) {
                Properties filterProperties = this.getBuildFilterProperties();
                for (Resource resource : webResources) {
                    this.copyResources(resource, webappDirectory, filterProperties);
                }
            }
            this.copyResources(this.warSourceDirectory, webappDirectory);
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                metainfDir = new File(webappDirectory, META_INF);
                String xmlFileName = this.containerConfigXML.getName();
                AbstractHpiMojo.copyFileIfModified(this.containerConfigXML, new File(metainfDir, xmlFileName));
            }
            this.buildWebapp(this.project, webappDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
    }

    private Properties getBuildFilterProperties() throws MojoExecutionException {
        Properties filterProperties = new Properties(System.getProperties());
        filterProperties.putAll((Map<?, ?>)this.project.getProperties());
        for (String filter : this.filters) {
            try {
                Properties properties = PropertyUtils.loadPropertyFile(new File(filter), true, true);
                filterProperties.putAll((Map<?, ?>)properties);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error loading property file '" + filter + "'", (Exception)e);
            }
        }
        return filterProperties;
    }

    public void copyResources(Resource resource, File webappDirectory, Properties filterProperties) throws IOException {
        if (!resource.getDirectory().equals(webappDirectory.getPath())) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (webappDirectory.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = this.getWarFiles(resource)) {
                    if (resource.isFiltering()) {
                        AbstractHpiMojo.copyFilteredFile(new File(resource.getDirectory(), fileName), new File(webappDirectory, fileName), null, this.getFilterWrappers(), filterProperties);
                        continue;
                    }
                    AbstractHpiMojo.copyFileIfModified(new File(resource.getDirectory(), fileName), new File(webappDirectory, fileName));
                }
            }
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp webResources to " + webappDirectory.getAbsolutePath()));
            if (this.warSourceDirectory.exists()) {
                String[] fileNames;
                for (String fileName : fileNames = this.getWarFiles(sourceDirectory)) {
                    AbstractHpiMojo.copyFileIfModified(new File(sourceDirectory, fileName), new File(webappDirectory, fileName));
                }
            }
        }
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        File webappClassesDirectory = new File(webappDirectory, "WEB-INF/classes");
        if (this.classesDirectory.exists() && !this.classesDirectory.equals(webappClassesDirectory)) {
            AbstractHpiMojo.copyDirectoryStructureIfModified(this.classesDirectory, webappClassesDirectory);
        }
        Set artifacts = project.getArtifacts();
        List<String> duplicates = this.findDuplicates(artifacts);
        ArrayList<File> dependentWarDirectories = new ArrayList<File>();
        for (Artifact artifact : artifacts) {
            String targetFileName = this.getDefaultFinalName(artifact);
            this.getLog().debug((CharSequence)("Processing: " + targetFileName));
            if (duplicates.contains(targetFileName)) {
                this.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                targetFileName = artifact.getGroupId() + "-" + targetFileName;
                this.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
            }
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            String type = artifact.getType();
            if ("tld".equals(type)) {
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(tldDirectory, targetFileName));
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("par".equals(type)) {
                targetFileName = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                this.getLog().debug((CharSequence)("Copying " + artifact.getFile() + " to " + new File(libDirectory, targetFileName)));
                AbstractHpiMojo.copyFileIfModified(artifact.getFile(), new File(libDirectory, targetFileName));
                continue;
            }
            if ("war".equals(type)) {
                dependentWarDirectories.add(this.unpackWarToTempDirectory(artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
        if (dependentWarDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependentWarDirectories.size() + " war(s)."));
            Iterator iter = dependentWarDirectories.iterator();
            while (iter.hasNext()) {
                this.copyDependentWarContents((File)iter.next(), webappDirectory);
            }
        }
    }

    private List<String> findDuplicates(Set<Artifact> artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String candidate = this.getDefaultFinalName(artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }

    private File unpackWarToTempDirectory(Artifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!tempLocation.exists()) {
            tempLocation.mkdirs();
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    private void copyDependentWarContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependentWarExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependentWarIncludes());
        scanner.scan();
        for (String dir : scanner.getIncludedDirectories()) {
            new File(targetDir, dir).mkdirs();
        }
        for (String file : scanner.getIncludedFiles()) {
            File targetFile = new File(targetDir, file);
            if (targetFile.exists()) continue;
            try {
                targetFile.getParentFile().mkdirs();
                AbstractHpiMojo.copyFileIfModified(new File(srcDir, file), targetFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + file + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private String[] getWarFiles(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(EMPTY_STRING_ARRAY));
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(EMPTY_STRING_ARRAY));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static void copyFileToDirectoryIfModified(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        AbstractHpiMojo.copyFileIfModified(source, new File(destinationDirectory, source.getName()));
    }

    private FilterWrapper[] getFilterWrappers() {
        return new FilterWrapper[]{new FilterWrapper(){

            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "${", "}");
            }
        }, new FilterWrapper(){

            public Reader getReader(Reader fileReader, Properties filterProperties) {
                return new InterpolationFilterReader(fileReader, (Map)filterProperties, "@", "@");
            }
        }};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFilteredFile(File from, File to, String encoding, FilterWrapper[] wrappers, Properties filterProperties) throws IOException {
        BufferedReader fileReader = null;
        OutputStreamWriter fileWriter = null;
        try {
            to.getParentFile().mkdirs();
            if (encoding == null || encoding.length() < 1) {
                fileReader = new BufferedReader(new FileReader(from));
                fileWriter = new FileWriter(to);
            } else {
                FileInputStream instream = new FileInputStream(from);
                FileOutputStream outstream = new FileOutputStream(to);
                fileReader = new BufferedReader(new InputStreamReader((InputStream)instream, encoding));
                fileWriter = new OutputStreamWriter((OutputStream)outstream, encoding);
            }
            Reader reader = fileReader;
            for (FilterWrapper wrapper : wrappers) {
                reader = wrapper.getReader(reader, filterProperties);
            }
            IOUtil.copy((Reader)reader, (Writer)fileWriter);
        }
        catch (Throwable throwable) {
            IOUtil.close(fileReader);
            IOUtil.close(fileWriter);
            throw throwable;
        }
        IOUtil.close((Reader)fileReader);
        IOUtil.close((Writer)fileWriter);
    }

    private static void copyFileIfModified(File source, File destination) throws IOException {
        if (destination.lastModified() < source.lastModified()) {
            FileUtils.copyFile((File)source, (File)destination);
        }
    }

    private static void copyDirectoryStructureIfModified(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new IOException("Source directory doesn't exists (" + sourceDirectory.getAbsolutePath() + ").");
        }
        String sourcePath = sourceDirectory.getAbsolutePath();
        for (File file : sourceDirectory.listFiles()) {
            String dest = file.getAbsolutePath();
            dest = dest.substring(sourcePath.length() + 1);
            File destination = new File(destinationDirectory, dest);
            if (file.isFile()) {
                destination = destination.getParentFile();
                AbstractHpiMojo.copyFileToDirectoryIfModified(file, destination);
                continue;
            }
            if (file.isDirectory()) {
                if (!destination.exists() && !destination.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + destination.getAbsolutePath() + "'.");
                }
                AbstractHpiMojo.copyDirectoryStructureIfModified(file, destination);
                continue;
            }
            throw new IOException("Unknown file type: " + file.getAbsolutePath());
        }
    }

    private String getDefaultFinalName(Artifact artifact) {
        return artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
    }

    protected void setAttributes(Manifest.Section mainSection) throws MojoExecutionException, ManifestException {
        JavaClass javaClass = this.findPluginClass();
        if (javaClass == null) {
            throw new MojoExecutionException("Unable to find a plugin class. Did you put @plugin in javadoc?");
        }
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Plugin-Class", javaClass.getPackage() + "." + javaClass.getName()));
        mainSection.addAttributeAndCheck(new Manifest.Attribute("Long-Name", this.pluginName));
    }

    private JavaClass findPluginClass() {
        JavaDocBuilder builder = new JavaDocBuilder();
        for (Object o : this.project.getCompileSourceRoots()) {
            builder.addSourceTree(new File((String)o));
        }
        for (JavaSource js : builder.getSources()) {
            JavaClass jc = js.getClasses()[0];
            if (jc.getTagByName("plugin") == null) continue;
            return jc;
        }
        return null;
    }

    private static interface FilterWrapper {
        public Reader getReader(Reader var1, Properties var2);
    }
}

