/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hpi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mortbay.jetty.plugin.util.JettyPluginServer;
import org.mortbay.jetty.plugin.util.JettyPluginWebApplication;
import org.mortbay.jetty.plugin.util.PluginLog;
import org.mortbay.jetty.plugin.util.Scanner;
import org.mortbay.jetty.plugin.util.SystemProperty;

public abstract class AbstractJettyMojo
extends AbstractMojo {
    private JettyPluginWebApplication webapp;
    private JettyPluginServer server;
    private MavenProject project;
    private String contextPath;
    private File tmpDirectory;
    private File webDefaultXml;
    private int scanIntervalSeconds;
    private SystemProperty[] systemProperties;
    private String jettyConfig;
    private ArrayList scanList;
    private ArrayList scannerListeners;
    public String PORT_SYSPROPERTY = "jetty.port";

    public abstract Object[] getConfiguredUserRealms();

    public abstract Object[] getConfiguredConnectors();

    public abstract Object getConfiguredRequestLog();

    public abstract void checkPomConfiguration() throws MojoExecutionException;

    public abstract void configureScanner() throws MojoExecutionException;

    public abstract void applyJettyXml() throws Exception;

    public abstract JettyPluginServer createServer() throws Exception;

    public abstract void finishConfigurationBeforeStart() throws Exception;

    public MavenProject getProject() {
        return this.project;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public File getWebDefaultXml() {
        return this.webDefaultXml;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public SystemProperty[] getSystemProperties() {
        return this.systemProperties;
    }

    public String getJettyXmlFileName() {
        return this.jettyConfig;
    }

    public JettyPluginWebApplication getWebApplication() {
        return this.webapp;
    }

    public void setWebApplication(JettyPluginWebApplication webapp) {
        this.webapp = webapp;
    }

    public JettyPluginServer getServer() {
        return this.server;
    }

    public void setServer(JettyPluginServer server) {
        this.server = server;
    }

    public void setScanList(ArrayList list) {
        this.scanList = new ArrayList(list);
    }

    public ArrayList getScanList() {
        return this.scanList;
    }

    public void setScannerListeners(ArrayList listeners) {
        this.scannerListeners = new ArrayList(listeners);
    }

    public ArrayList getScannerListeners() {
        return this.scannerListeners;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Configuring Jetty for project: " + this.getProject().getName()));
        PluginLog.setLog((Log)this.getLog());
        this.checkPomConfiguration();
        this.startJetty();
    }

    public void startJetty() throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Starting Jetty Server ...");
            this.configureSystemProperties();
            this.setServer(this.createServer());
            this.applyJettyXml();
            JettyPluginServer plugin = this.getServer();
            Object[] configuredConnectors = this.getConfiguredConnectors();
            if (configuredConnectors == null || configuredConnectors.length == 0) {
                configuredConnectors = new Object[]{plugin.createDefaultConnector(System.getProperty(this.PORT_SYSPROPERTY, null))};
            }
            plugin.setConnectors(configuredConnectors);
            if (this.getConfiguredRequestLog() != null) {
                this.getServer().setRequestLog(this.getConfiguredRequestLog());
            }
            this.getServer().configureHandlers();
            this.setWebApplication(this.getServer().createWebApplication());
            this.configureWebApplication();
            this.getServer().addWebApplication(this.getWebApplication());
            Object[] configuredRealms = this.getConfiguredUserRealms();
            for (int i = 0; configuredRealms != null && i < configuredRealms.length; ++i) {
                this.getLog().debug((CharSequence)(configuredRealms[i].getClass().getName() + ": " + configuredRealms[i].toString()));
            }
            plugin.setUserRealms(configuredRealms);
            this.finishConfigurationBeforeStart();
            this.server.start();
            this.getLog().info((CharSequence)"Started Jetty Server");
            this.configureScanner();
            this.startScanner();
            this.server.join();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure", e);
        }
        finally {
            this.getLog().info((CharSequence)"Jetty server exiting.");
        }
    }

    public void configureWebApplication() throws Exception {
        if (this.getWebApplication() == null) {
            return;
        }
        JettyPluginWebApplication webapp = this.getWebApplication();
        webapp.setTempDirectory(this.getTmpDirectory());
        webapp.setWebDefaultXmlFile(this.getWebDefaultXml());
        String contextPath = this.getContextPath();
        webapp.setContextPath(contextPath.startsWith("/") ? contextPath : "/" + contextPath);
        this.getLog().info((CharSequence)("Context path = " + webapp.getContextPath()));
        this.getLog().info((CharSequence)("Tmp directory = " + (this.getTmpDirectory() == null ? " jetty default" : this.getTmpDirectory().toString())));
        this.getLog().info((CharSequence)("Web defaults = " + (this.getWebDefaultXml() == null ? " jetty default" : this.getWebDefaultXml().toString())));
    }

    private void startScanner() {
        if (this.getScanIntervalSeconds() <= 0) {
            return;
        }
        Scanner scanner = new Scanner();
        scanner.setScanInterval(this.getScanIntervalSeconds());
        scanner.setRoots((List)this.getScanList());
        scanner.setListeners((List)this.getScannerListeners());
        this.getLog().info((CharSequence)("Starting scanner at interval of " + this.getScanIntervalSeconds() + " seconds."));
        scanner.start();
    }

    private void configureSystemProperties() {
        for (int i = 0; this.getSystemProperties() != null && i < this.getSystemProperties().length; ++i) {
            boolean result = this.getSystemProperties()[i].setIfNotSetAlready();
            this.getLog().info((CharSequence)("Property " + this.getSystemProperties()[i].getName() + "=" + this.getSystemProperties()[i].getValue() + " was " + (result ? "set" : "skipped")));
        }
    }

    public File findJettyWebXmlFile(File webInfDir) {
        if (webInfDir == null) {
            return null;
        }
        if (!webInfDir.exists()) {
            return null;
        }
        File f = new File(webInfDir, "jetty-web.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "web-jetty.xml");
        if (f.exists()) {
            return f;
        }
        f = new File(webInfDir, "jetty6-web.xml");
        if (f.exists()) {
            return f;
        }
        return null;
    }
}

