/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hpi;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.util.IOUtil;
import org.jvnet.hudson.maven.plugins.hpi.AbstractHpiMojo;

public class HpiMojo
extends AbstractHpiMojo {
    private String hpiName;
    private String classifier;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;
    private boolean primaryArtifact;

    protected String getClassifier() {
        return this.classifier;
    }

    protected static File getHpiFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".hpi");
    }

    public void execute() throws MojoExecutionException {
        File hpiFile = HpiMojo.getHpiFile(new File(this.outputDirectory), this.hpiName, this.classifier);
        try {
            this.performPackaging(hpiFile);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling hpi: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling hpi", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling hpi", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling hpi: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void performPackaging(File hpiFile) throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        this.buildExplodedWebapp(this.getWebappDirectory());
        this.getLog().info((CharSequence)("Generating hpi " + hpiFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(hpiFile);
        File manifestFile = new File(this.getWebappDirectory(), "META-INF/MANIFEST.MF");
        this.generateManifest(manifestFile);
        this.jarArchiver.setManifest(manifestFile);
        this.jarArchiver.addDirectory(this.getWebappDirectory(), this.getIncludes(), this.getExcludes());
        archiver.createArchive(this.project, this.archive);
        String classifier = this.classifier;
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.project, "hpi", classifier, hpiFile);
        } else {
            Artifact artifact = this.project.getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(hpiFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(hpiFile);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateManifest(File manifestFile) throws MojoExecutionException {
        if (manifestFile.exists()) {
            return;
        }
        if (!manifestFile.getParentFile().exists()) {
            manifestFile.getParentFile().mkdirs();
        }
        this.getLog().info((CharSequence)("Generating " + manifestFile));
        MavenArchiver ma = new MavenArchiver();
        ma.setOutputFile(manifestFile);
        PrintWriter printWriter = null;
        try {
            Manifest mf = ma.getManifest(this.project, this.archive.getManifest());
            Manifest.Section mainSection = mf.getMainSection();
            this.setAttributes(mainSection);
            printWriter = new PrintWriter(new FileWriter(manifestFile));
            mf.write(printWriter);
        }
        catch (ManifestException e) {
            try {
                throw new MojoExecutionException("Error preparing the manifest: " + e.getMessage(), (Exception)((Object)e));
                catch (DependencyResolutionRequiredException e2) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e2.getMessage(), (Exception)((Object)e2));
                }
                catch (IOException e3) {
                    throw new MojoExecutionException("Error preparing the manifest: " + e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(printWriter);
                throw throwable;
            }
        }
        IOUtil.close((Writer)printWriter);
    }
}

