/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hpi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jvnet.hudson.maven.plugins.hpi.AbstractJetty6Mojo;
import org.jvnet.hudson.maven.plugins.hpi.HplMojo;
import org.mortbay.jetty.plugin.util.Scanner;
import org.mortbay.jetty.plugin.util.SystemProperty;

public class RunMojo
extends AbstractJetty6Mojo {
    private File webApp;
    private File hudsonHome;
    protected File warSourceDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Artifact a : this.getProject().getArtifacts()) {
            if (!a.getArtifactId().equals("hudson-war") || !a.getType().equals("war")) continue;
            this.webApp = a.getFile();
        }
        if (this.webApp == null) {
            this.getLog().error((CharSequence)"Unable to locate hudson.war. Add the following dependency in your POM:\n\n<dependency>\n  <groupId>org.jvnet.hudson.main</groupId>\n  <artifactId>hudson-war</artifactId>\n  <type>war</type>\n  <version>1.60<!-- replace this with the version you want--></version>\n  <scope>test</scope>\n</dependency>");
            throw new MojoExecutionException("Unable to find hudson.war");
        }
        SystemProperty sp = new SystemProperty();
        sp.setName("HUDSON_HOME");
        sp.setValue(this.hudsonHome.getAbsolutePath());
        sp.setIfNotSetAlready();
        new File(this.hudsonHome, "plugins").mkdirs();
        sp = new SystemProperty();
        sp.setName("stapler.jelly.noCache");
        sp.setValue("true");
        sp.setIfNotSetAlready();
        this.generateHpl();
        super.execute();
    }

    private void generateHpl() throws MojoExecutionException, MojoFailureException {
        HplMojo hpl = new HplMojo();
        hpl.project = this.getProject();
        hpl.setHudsonHome(this.hudsonHome);
        hpl.setLog(this.getLog());
        hpl.pluginName = this.getProject().getName();
        hpl.warSourceDirectory = this.warSourceDirectory;
        hpl.execute();
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.getWebApplication().setWebAppSrcDir(this.webApp);
    }

    public void configureScanner() throws MojoExecutionException {
        this.setUpScanList(new ArrayList());
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.Listener(){

            public void changesDetected(Scanner scanner, List changes) {
                try {
                    RunMojo.this.getLog().info((CharSequence)"Restarting webapp ...");
                    RunMojo.this.getLog().debug((CharSequence)"Stopping webapp ...");
                    RunMojo.this.getWebApplication().stop();
                    RunMojo.this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                    RunMojo.this.checkPomConfiguration();
                    if (changes.contains(RunMojo.this.getProject().getFile().getCanonicalPath())) {
                        RunMojo.this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                        RunMojo.this.generateHpl();
                        ArrayList scanList = RunMojo.this.getScanList();
                        scanList.clear();
                        RunMojo.this.setUpScanList(scanList);
                        scanner.setRoots((List)scanList);
                    }
                    RunMojo.this.getLog().debug((CharSequence)"Restarting webapp ...");
                    RunMojo.this.getWebApplication().start();
                    RunMojo.this.getLog().info((CharSequence)"Restart completed.");
                }
                catch (Exception e) {
                    RunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    private void setUpScanList(ArrayList scanList) {
        scanList.add(this.getProject().getFile());
        scanList.add(this.webApp);
        scanList.add(new File(this.getProject().getBuild().getOutputDirectory()));
        this.setScanList(scanList);
    }

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void finishConfigurationBeforeStart() {
    }
}

