/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hudson;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHudsonMojo
extends AbstractMojo {
    protected final HttpClient httpClient = new HttpClient();
    protected URL hudsonURL;
    protected MavenProject project;
    protected Settings settings;
    private final XMLOutputter xmlOutputter = new XMLOutputter();

    protected void configurePlugin(Document jobDoc, PluginType pluginType, Element element) {
        Element plugins = jobDoc.getRootElement().getChild(pluginType.name());
        if (plugins.getChild(element.getName()) != null) {
            plugins.removeChild(element.getName());
        }
        plugins.addContent((Content)element);
    }

    protected void createHudsonURL() throws MojoExecutionException {
        try {
            if (this.hudsonURL == null && this.project != null && this.project.getCiManagement() != null && "hudson".equals(this.project.getCiManagement().getSystem())) {
                this.hudsonURL = new URL(this.project.getCiManagement().getUrl());
            }
            if (this.hudsonURL == null) {
                throw new MojoExecutionException("No hudson url defined.");
            }
            String hudsonURLAsString = this.hudsonURL.toString();
            if (hudsonURLAsString.endsWith("/")) {
                hudsonURLAsString = hudsonURLAsString.substring(0, hudsonURLAsString.length() - 1);
                this.hudsonURL = new URL(hudsonURLAsString);
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to create URL", (Exception)e);
        }
        this.getLog().info((CharSequence)("Base Hudson URL is " + this.hudsonURL));
    }

    protected URL createJobBuildURL(String jobName) throws MojoExecutionException {
        jobName = jobName.replace(" ", "%20");
        try {
            return new URL(String.format("%s/job/%s/build", this.hudsonURL, jobName));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to construct a job build URL", (Exception)e);
        }
    }

    protected URL createJobConfigURL(String jobName) throws MojoExecutionException {
        jobName = jobName.replace(" ", "%20");
        try {
            return new URL(String.format("%s/job/%s/config.xml", this.hudsonURL, jobName));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to construct a job build URL", (Exception)e);
        }
    }

    protected URL createJobListURL() throws MojoExecutionException {
        try {
            return new URL(String.format("%s/api/xml?xpath=/hudson/job/name&wrapper=jobs", this.hudsonURL));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to construct a job list URL", (Exception)e);
        }
    }

    protected void createOrChange(Element element, String name, int value) {
        this.createOrChange(element, name, String.valueOf(value));
    }

    protected void createOrChange(Element element, String name, String value) {
        Element child = element.getChild(name);
        if (child == null) {
            child = new Element(name);
            element.addContent((Content)child);
        }
        child.setText(value);
    }

    protected void doPost(URL url, int expectedStatus) throws IOException, MojoExecutionException {
        this.doPost(url, null, expectedStatus);
    }

    protected void doPost(URL url, RequestEntity requestEntity, int expectedStatus) throws IOException, MojoExecutionException {
        int status;
        PostMethod pm = new PostMethod(url.toString());
        if (requestEntity != null) {
            pm.setRequestEntity(requestEntity);
        }
        if ((status = this.httpClient.executeMethod((HttpMethod)pm)) != expectedStatus) {
            throw new MojoExecutionException("Incorrect status back from Hudson: " + status + ". Expected: " + expectedStatus);
        }
    }

    protected Server findServer() {
        if (this.settings == null) {
            return null;
        }
        String serverID = this.hudsonURL.getHost();
        if (this.hudsonURL.getPort() != -1 && this.hudsonURL.getPort() != this.hudsonURL.getDefaultPort()) {
            serverID = serverID + ":" + this.hudsonURL.getPort();
        }
        return this.settings.getServer(serverID);
    }

    protected void forEachJob(JobClosure closure) throws MojoExecutionException {
        List<String> jobList = null;
        try {
            jobList = this.getJobList();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to obtain job list", (Exception)e);
        }
        for (String job : jobList) {
            closure.doWithJob(job);
        }
    }

    protected Document getDocumentFromHudson(URL url) throws MojoExecutionException {
        try {
            GetMethod gm = new GetMethod(url.toString());
            int status = this.httpClient.executeMethod((HttpMethod)gm);
            if (status != 200) {
                throw new MojoExecutionException("Non-OK status back from Hudson: " + status);
            }
            return new SAXBuilder().build(gm.getResponseBodyAsStream());
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Unable to parse " + url.toString(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to parse " + url.toString(), (Exception)e);
        }
    }

    protected List<String> getJobList() throws MojoExecutionException, IOException {
        URL jobListURL = this.createJobListURL();
        Document doc = this.getDocumentFromHudson(jobListURL);
        List nodes = doc.getRootElement().getChildren("name");
        ArrayList<String> retval = new ArrayList<String>(nodes.size());
        for (Element node : nodes) {
            retval.add(node.getTextNormalize());
        }
        return retval;
    }

    protected Document loadJobConfig(String name) throws MojoExecutionException {
        URL configURL = this.createJobConfigURL(name);
        return this.getDocumentFromHudson(configURL);
    }

    protected void rebuildJob(String job) throws MojoExecutionException {
        URL buildURL = this.createJobBuildURL(job);
        try {
            this.doPost(buildURL, 302);
        }
        catch (HttpException e) {
            throw new MojoExecutionException("Unable to rebuild job " + job, (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to rebuild job " + job, (Exception)e);
        }
    }

    protected void saveJobConfig(String name, Document jobDoc) throws MojoExecutionException {
        URL configURL = this.createJobConfigURL(name);
        String payload = this.xmlOutputter.outputString(jobDoc);
        try {
            this.doPost(configURL, (RequestEntity)new StringRequestEntity(payload, "text/xml", "UTF-8"), 200);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception posting payload to " + configURL, (Exception)e);
        }
    }

    protected void setupClient() {
        Server server = this.findServer();
        if (server != null) {
            this.httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(server.getUsername(), server.getPassword());
            this.httpClient.getState().setCredentials(new AuthScope(this.hudsonURL.getHost(), this.hudsonURL.getPort(), AuthScope.ANY_REALM), (Credentials)defaultcreds);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PluginType {
        builders,
        publishers,
        triggers;

    }

    protected static interface JobClosure {
        public void doWithJob(String var1) throws MojoExecutionException;
    }
}

