/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hudson;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jvnet.hudson.maven.plugins.hudson.AbstractHudsonMojo;

public class AdjustViolationsMojo
extends AbstractHudsonMojo {
    private String jobName;
    private int max;
    private int min;
    private int unstable;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupClient();
        if (this.jobName == null) {
            throw new MojoExecutionException("No job name specified");
        }
        this.changeJob(this.jobName);
        this.rebuildJob(this.jobName);
    }

    protected void changeJob(String name) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Modifying job: " + name));
        Document jobDoc = this.loadJobConfig(name);
        try {
            this.changeViolations(jobDoc);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Unable to change violations.");
        }
        this.saveJobConfig(name, jobDoc);
    }

    protected boolean changeViolations(Document jobDoc) throws JDOMException {
        List typeConfigs = XPath.selectNodes((Object)jobDoc, (String)"/project/publishers/hudson.plugins.violations.ViolationsPublisher/config/typeConfigs/entry/hudson.plugins.violations.TypeConfig");
        if (typeConfigs.isEmpty()) {
            return false;
        }
        for (Element typeConfig : typeConfigs) {
            this.createOrChange(typeConfig, "min", this.min);
            this.createOrChange(typeConfig, "max", this.max);
            this.createOrChange(typeConfig, "unstable", this.unstable);
        }
        return true;
    }
}

