/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.maven.plugins.hudson;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.jvnet.hudson.maven.plugins.hudson.AbstractHudsonMojo;

public class AddJobMojo
extends AbstractHudsonMojo {
    private static final Map<String, List<String>> GOALS = new HashMap<String, List<String>>();
    private static final List<String> PLUGINS = Arrays.asList("cobertura", "violations", "javadoc");
    private static final Map<String, List<String>> PREFIXES = new HashMap<String, List<String>>();
    private String additionalGoals;
    private String allocatePorts;
    private String description;
    private boolean includeCobertura = true;
    private boolean includeEmail = true;
    private boolean includeJavadoc = true;
    private boolean includeJunit = true;
    private boolean includeTwitter = true;
    private boolean includeViolations = true;
    private String jobName;
    private boolean performClean;
    private String primaryGoal;
    private boolean shouldFailAtEnd = true;
    private boolean shouldUseBatchMode = true;
    private boolean startVNC;
    private String scmUrl;
    private boolean useMavenProjectType;

    public void execute() throws MojoExecutionException {
        if (this.project == null) {
            throw new MojoExecutionException("This mojo must be run in the context of a project.");
        }
        this.createHudsonURL();
        this.setupClient();
        if (!this.jobExists()) {
            URL postURL = this.createPostURL();
            this.getLog().info((CharSequence)("posting job to " + postURL));
            String payload = this.createPayload();
            this.postPayload(postURL, payload);
        } else {
            this.getLog().warn((CharSequence)"Job exists; not overwriting.");
        }
    }

    protected String createPayload() throws MojoExecutionException {
        try {
            Velocity.init();
            VelocityContext ctx = new VelocityContext();
            ctx.put("project", (Object)this.project);
            ctx.put("goals", (Object)this.createFullGoals());
            String scmElement = this.createSCMElement();
            ctx.put("scmElement", (Object)scmElement);
            this.addIncludes(ctx);
            if (this.allocatePorts != null) {
                ctx.put("ports", (Object)this.allocatePorts.split(","));
            }
            ctx.put("startVNC", (Object)this.startVNC);
            if (this.description != null) {
                ctx.put("description", (Object)this.description);
            } else {
                ctx.put("description", (Object)"");
            }
            StringWriter sw = new StringWriter();
            String template = "project-template.vm";
            if (this.useMavenProjectType) {
                template = "maven-template.vm";
            }
            Velocity.evaluate((Context)ctx, (Writer)sw, (String)template, (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/" + template));
            return sw.toString();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to evaluate template", e);
        }
    }

    private String createSCMElement() throws IOException {
        VelocityContext ctx1 = new VelocityContext();
        if (this.scmUrl.startsWith("scm:svn:")) {
            ctx1.put("scmType", (Object)"subversion");
            ctx1.put("scmURL", (Object)this.scmUrl.replace("scm:svn:", ""));
        } else if (this.scmUrl.startsWith("scm:git:")) {
            ctx1.put("scmType", (Object)"git");
            String gitUrl = this.scmUrl.replace("scm:git:", "");
            ctx1.put("scmURL", (Object)gitUrl);
        }
        StringWriter sw1 = new StringWriter();
        Velocity.evaluate((Context)ctx1, (Writer)sw1, (String)"project-template.vm", (InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/scm-template.vm"));
        return sw1.toString();
    }

    protected URL createPostURL() throws MojoExecutionException {
        try {
            return new URL(String.format("%s/createItem?name=%s", this.hudsonURL, this.getJobName()));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to creat post URL", (Exception)e);
        }
    }

    protected String getJobName() {
        if (this.jobName != null) {
            return this.jobName;
        }
        return this.project.getArtifactId();
    }

    protected boolean jobExists() throws MojoExecutionException {
        String jobURL = String.format("%s/api/xml?xpath=/hudson/job[name='%s']", this.hudsonURL, this.getJobName());
        GetMethod gm = new GetMethod(jobURL);
        try {
            int status = this.httpClient.executeMethod((HttpMethod)gm);
            return status != 404;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to check if job currently exists", (Exception)e);
        }
    }

    protected void postPayload(URL postURL, String payload) throws MojoExecutionException {
        try {
            this.doPost(postURL, (RequestEntity)new StringRequestEntity(payload, "text/xml", "UTF-8"), 200);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception posting payload to " + postURL, (Exception)e);
        }
    }

    private void addIncludes(VelocityContext ctx) throws IllegalAccessException {
        Field[] fields = AddJobMojo.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().startsWith("include")) continue;
            ctx.put(field.getName(), (Object)field.getBoolean((Object)this));
        }
    }

    private String createFullGoals() throws MojoExecutionException {
        try {
            StringBuilder builder = new StringBuilder();
            if (!this.useMavenProjectType) {
                if (this.shouldFailAtEnd) {
                    builder.append("-fae ");
                }
                if (this.shouldUseBatchMode) {
                    builder.append("-B ");
                }
                for (String plugin : PLUGINS) {
                    if (!this.isPluginEnabled(plugin) || !PREFIXES.containsKey(plugin)) continue;
                    builder.append(StringUtils.join((Object[])PREFIXES.get(plugin).toArray(), (String)" "));
                    builder.append(" ");
                }
            }
            if (this.performClean) {
                builder.append("clean ");
            }
            builder.append(this.primaryGoal);
            builder.append(" ");
            if (!this.useMavenProjectType) {
                for (String plugin : PLUGINS) {
                    if (!this.isPluginEnabled(plugin) || !GOALS.containsKey(plugin)) continue;
                    builder.append(StringUtils.join((Object[])GOALS.get(plugin).toArray(), (String)" "));
                    builder.append(" ");
                }
            }
            if (this.additionalGoals != null) {
                builder.append(this.additionalGoals);
            }
            return builder.toString().trim();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception while creating goals", e);
        }
    }

    private boolean isPluginEnabled(String plugin) throws NoSuchFieldException, IllegalAccessException {
        String fieldName = "include" + plugin.substring(0, 1).toUpperCase() + plugin.substring(1);
        Field field = AddJobMojo.class.getDeclaredField(fieldName);
        return field.getBoolean((Object)this);
    }

    static {
        PREFIXES.put("javadoc", Arrays.asList("-Daggregate=true"));
        GOALS.put("cobertura", Arrays.asList("cobertura:cobertura"));
        GOALS.put("javadoc", Arrays.asList("javadoc:javadoc"));
        GOALS.put("violations", Arrays.asList("pmd:pmd", "pmd:cpd", "findbugs:findbugs", "checkstyle:checkstyle"));
    }
}

