/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.mortbay.jetty.plugin.AbstractJettyMojo;
import org.mortbay.jetty.plugin.util.JettyPluginWebApplication;
import org.mortbay.jetty.plugin.util.ScanTargetPattern;
import org.mortbay.util.Scanner;

public abstract class AbstractJettyRunMojo
extends AbstractJettyMojo {
    private boolean useTestClasspath;
    private String jettyEnvXml;
    private String webXml;
    private File classesDirectory;
    private File testClassesDirectory;
    private File webAppSourceDirectory;
    private List pluginArtifacts;
    private File[] scanTargets;
    private ScanTargetPattern[] scanTargetPatterns;
    private File webXmlFile;
    private File jettyEnvXmlFile;
    private List classPathFiles;
    private List extraScanTargets;

    public String getWebXml() {
        return this.webXml;
    }

    public String getJettyEnvXml() {
        return this.jettyEnvXml;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public File getWebAppSourceDirectory() {
        return this.webAppSourceDirectory;
    }

    public void setWebXmlFile(File f) {
        this.webXmlFile = f;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public File getJettyEnvXmlFile() {
        return this.jettyEnvXmlFile;
    }

    public void setJettyEnvXmlFile(File f) {
        this.jettyEnvXmlFile = f;
    }

    public void setClassPathFiles(List list) {
        this.classPathFiles = new ArrayList(list);
    }

    public List getClassPathFiles() {
        return this.classPathFiles;
    }

    public List getExtraScanTargets() {
        return this.extraScanTargets;
    }

    public void setExtraScanTargets(List list) {
        this.extraScanTargets = list;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public void checkPomConfiguration() throws MojoExecutionException {
        try {
            if (this.getWebAppSourceDirectory() == null || !this.getWebAppSourceDirectory().exists()) {
                throw new MojoExecutionException("Webapp source directory " + (this.getWebAppSourceDirectory() == null ? "null" : this.getWebAppSourceDirectory().getCanonicalPath()) + " does not exist");
            }
            this.getLog().info((CharSequence)("Webapp source directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (this.getWebXml() == null || this.getWebXml().trim().equals("")) {
            this.setWebXmlFile(new File(new File(this.getWebAppSourceDirectory(), "WEB-INF"), "web.xml"));
        } else {
            this.setWebXmlFile(new File(this.getWebXml()));
        }
        try {
            if (!this.getWebXmlFile().exists()) {
                throw new MojoExecutionException("web.xml does not exist at location " + this.webXmlFile.getCanonicalPath());
            }
            this.getLog().info((CharSequence)("web.xml file = " + this.webXmlFile.getCanonicalPath()));
        }
        catch (IOException e) {
            throw new MojoExecutionException("web.xml does not exist", (Exception)e);
        }
        if (this.getJettyEnvXml() != null) {
            this.setJettyEnvXmlFile(new File(this.getJettyEnvXml()));
            try {
                if (!this.getJettyEnvXmlFile().exists()) {
                    throw new MojoExecutionException("jetty-env.xml file does not exist at location " + this.jettyEnvXml);
                }
                this.getLog().info((CharSequence)(" jetty-env.xml = " + this.getJettyEnvXmlFile().getCanonicalPath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("jetty-env.xml does not exist");
            }
        }
        try {
            if (this.getClassesDirectory() != null) {
                if (!this.getClassesDirectory().exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.getClassesDirectory().getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.getClassesDirectory().getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        if (this.getTmpDirectory() != null && !this.getTmpDirectory().exists() && !this.getTmpDirectory().mkdirs()) {
            throw new MojoExecutionException("Unable to create tmp directory at " + this.getTmpDirectory());
        }
        if (this.scanTargets == null) {
            this.setExtraScanTargets(Collections.EMPTY_LIST);
        } else {
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < this.scanTargets.length; ++i) {
                this.getLog().info((CharSequence)("Added extra scan target:" + this.scanTargets[i]));
                list.add(this.scanTargets[i]);
            }
            this.setExtraScanTargets(list);
        }
        if (this.scanTargetPatterns != null) {
            for (int i = 0; i < this.scanTargetPatterns.length; ++i) {
                Iterator itor = this.scanTargetPatterns[i].getIncludes().iterator();
                StringBuffer strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String includes = strbuff.toString();
                itor = this.scanTargetPatterns[i].getExcludes().iterator();
                strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String excludes = strbuff.toString();
                try {
                    List files = FileUtils.getFiles((File)this.scanTargetPatterns[i].getDirectory(), (String)includes, (String)excludes);
                    itor = files.iterator();
                    while (itor.hasNext()) {
                        this.getLog().info((CharSequence)("Adding extra scan target from pattern: " + itor.next()));
                    }
                    this.setExtraScanTargets(files);
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        JettyPluginWebApplication webapp = this.getWebApplication();
        this.setClassPathFiles(this.setUpClassPath());
        webapp.setWebXmlFile(this.getWebXmlFile());
        webapp.setJettyEnvXmlFile(this.getJettyEnvXmlFile());
        webapp.setClassPathFiles(this.getClassPathFiles());
        webapp.setWebAppSrcDir(this.getWebAppSourceDirectory());
        this.getLog().info((CharSequence)("Webapp directory = " + this.getWebAppSourceDirectory().getCanonicalPath()));
        webapp.configure();
    }

    public void configureScanner() {
        File jettyWebXmlFile;
        final ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getWebXmlFile());
        if (this.getJettyEnvXmlFile() != null) {
            scanList.add(this.getJettyEnvXmlFile());
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.getWebAppSourceDirectory(), "WEB-INF"))) != null) {
            scanList.add(jettyWebXmlFile);
        }
        scanList.addAll(this.getExtraScanTargets());
        scanList.add(this.getProject().getFile());
        scanList.addAll(this.getClassPathFiles());
        this.setScanList(scanList);
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    AbstractJettyRunMojo.this.getLog().info((CharSequence)("restarting " + AbstractJettyRunMojo.this.getWebApplication()));
                    AbstractJettyRunMojo.this.getLog().debug((CharSequence)"Stopping webapp ...");
                    AbstractJettyRunMojo.this.getWebApplication().stop();
                    AbstractJettyRunMojo.this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
                    AbstractJettyRunMojo.this.checkPomConfiguration();
                    AbstractJettyRunMojo.this.configureWebApplication();
                    if (changes.contains(AbstractJettyRunMojo.this.getProject().getFile().getCanonicalPath())) {
                        AbstractJettyRunMojo.this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
                        scanList.clear();
                        scanList.add(AbstractJettyRunMojo.this.getWebXmlFile());
                        if (AbstractJettyRunMojo.this.getJettyEnvXmlFile() != null) {
                            scanList.add(AbstractJettyRunMojo.this.getJettyEnvXmlFile());
                        }
                        scanList.addAll(AbstractJettyRunMojo.this.getExtraScanTargets());
                        scanList.add(AbstractJettyRunMojo.this.getProject().getFile());
                        scanList.addAll(AbstractJettyRunMojo.this.getClassPathFiles());
                        AbstractJettyRunMojo.this.getScanner().setScanDirs((List)scanList);
                    }
                    AbstractJettyRunMojo.this.getLog().debug((CharSequence)"Restarting webapp ...");
                    AbstractJettyRunMojo.this.getWebApplication().start();
                    AbstractJettyRunMojo.this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
                }
                catch (Exception e) {
                    AbstractJettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    private List getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        Iterator iter = this.getProject().getArtifacts().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            if (("provided".equals(artifact.getScope()) || "test".equals(artifact.getScope())) && (!this.useTestClasspath || !"test".equals(artifact.getScope()))) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " for WEB-INF/lib "));
        }
        return dependencyFiles;
    }

    private List setUpClassPath() {
        ArrayList<File> classPathFiles = new ArrayList<File>();
        if (this.useTestClasspath && this.testClassesDirectory != null) {
            classPathFiles.add(this.testClassesDirectory);
        }
        if (this.getClassesDirectory() != null) {
            classPathFiles.add(this.getClassesDirectory());
        }
        classPathFiles.addAll(this.getDependencyFiles());
        if (this.getLog().isDebugEnabled()) {
            for (int i = 0; i < classPathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)("classpath element: " + ((File)classPathFiles.get(i)).getName()));
            }
        }
        return classPathFiles;
    }
}

