/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.mortbay.jetty.plugin.util.PluginLog;

public class RuntimeDependencyResolver {
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepository localRepository;
    private List remoteRepositories;

    public RuntimeDependencyResolver(ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactMetadataSource metadataSource, ArtifactRepository localRepository, List remoteRepositories) {
        this.artifactFactory = artifactFactory;
        this.artifactResolver = artifactResolver;
        this.metadataSource = metadataSource;
        this.localRepository = localRepository;
        this.remoteRepositories = new ArrayList(remoteRepositories);
    }

    public Set transitivelyResolvePomDependencies(MavenProjectBuilder projectBuilder, String groupId, String artifactId, String versionId, boolean resolveProjectArtifact) throws MalformedURLException, ProjectBuildingException, InvalidDependencyVersionException, ArtifactResolutionException, ArtifactNotFoundException {
        Artifact pomArtifact = this.getPomArtifact(groupId, artifactId, versionId);
        MavenProject project = this.loadPomAsProject(projectBuilder, pomArtifact);
        List dependencies = project.getDependencies();
        Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null);
        dependencyArtifacts.add(project.getArtifact());
        ArrayList<RuntimeResolutionListener> listeners = Collections.EMPTY_LIST;
        if (PluginLog.getLog().isDebugEnabled()) {
            listeners = new ArrayList<RuntimeResolutionListener>();
            listeners.add(new RuntimeResolutionListener());
        }
        ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, pomArtifact, Collections.EMPTY_MAP, this.localRepository, this.remoteRepositories, this.metadataSource, null, listeners);
        Set artifacts = result.getArtifacts();
        if (PluginLog.getLog().isDebugEnabled()) {
            PluginLog.getLog().debug((CharSequence)("RESOLVED " + artifacts.size() + " ARTIFACTS"));
            Iterator itor = artifacts.iterator();
            while (itor.hasNext()) {
                Artifact a = (Artifact)itor.next();
                PluginLog.getLog().debug((CharSequence)a.getFile().toURL().toString());
            }
        }
        return artifacts;
    }

    public MavenProject loadPomAsProject(MavenProjectBuilder projectBuilder, Artifact pomArtifact) throws ProjectBuildingException {
        return projectBuilder.buildFromRepository(pomArtifact, this.remoteRepositories, this.localRepository);
    }

    public Artifact getArtifact(String groupId, String artifactId, String versionId, String type) {
        return this.artifactFactory.createBuildArtifact(groupId, artifactId, versionId, type);
    }

    public Artifact getPomArtifact(String groupId, String artifactId, String versionId) {
        return this.artifactFactory.createBuildArtifact(groupId, artifactId, versionId, "pom");
    }

    public void removeDependency(Set artifacts, String groupId, String artifactId, String versionId, String type) {
        if (artifacts == null || artifacts.isEmpty()) {
            return;
        }
        Iterator itor = artifacts.iterator();
        while (itor.hasNext()) {
            Artifact a = (Artifact)itor.next();
            if (!a.getGroupId().equals(groupId) || !a.getArtifactId().equals(artifactId) || !a.getType().equals(type)) continue;
            if (versionId == null) {
                itor.remove();
                continue;
            }
            if (!a.getVersion().equals(versionId)) continue;
            itor.remove();
        }
    }

    public void addDependency(Set artifacts, String groupId, String artifactId, String versionId, String type) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact a = this.getArtifact(groupId, artifactId, versionId, type);
        this.artifactResolver.resolve(a, this.remoteRepositories, this.localRepository);
        artifacts.add(a);
    }

    class RuntimeResolutionListener
    implements ResolutionListener {
        RuntimeResolutionListener() {
        }

        public void testArtifact(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("TESTING ARTIFACT " + arg0));
        }

        public void startProcessChildren(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("STARTING CHILDREN " + arg0));
        }

        public void endProcessChildren(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("ENDING CHILDREN " + arg0));
        }

        public void includeArtifact(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("INCLUDE ARTIFACT " + arg0));
        }

        public void omitForNearer(Artifact arg0, Artifact arg1) {
            PluginLog.getLog().debug((CharSequence)("OMITTING " + arg0 + " for NEARER " + arg1));
        }

        public void updateScope(Artifact arg0, String arg1) {
            PluginLog.getLog().debug((CharSequence)("UPDATE of SCOPE " + arg0 + "=" + arg1));
        }

        public void manageArtifact(Artifact arg0, Artifact arg1) {
            PluginLog.getLog().debug((CharSequence)("MANAGE ARTIFACT " + arg0 + " and " + arg1));
        }

        public void omitForCycle(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("OMIT FOR CYCLE " + arg0));
        }

        public void updateScopeCurrentPom(Artifact arg0, String arg1) {
            PluginLog.getLog().debug((CharSequence)("UPDATE SCOPE CURRENT POM " + arg0 + "=" + arg1));
        }

        public void selectVersionFromRange(Artifact arg0) {
            PluginLog.getLog().debug((CharSequence)("SELECT VERSION FROM RANGE " + arg0));
        }

        public void restrictRange(Artifact arg0, Artifact arg1, VersionRange arg2) {
            PluginLog.getLog().debug((CharSequence)("RESTRICT RANGE " + arg0 + " " + arg1 + " range=" + arg2));
        }
    }
}

