/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumberBuilder
extends BuildWrapper {
    private static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final String versionNumberString;
    private final Date projectStartDate;
    private final String environmentVariableName;
    private int oBuildsToday;
    private int oBuildsThisMonth;
    private int oBuildsThisYear;
    private int oBuildsAllTime;

    @DataBoundConstructor
    public VersionNumberBuilder(String versionNumberString, String projectStartDate, String environmentVariableName, String buildsToday, String buildsThisMonth, String buildsThisYear, String buildsAllTime) {
        this.versionNumberString = versionNumberString;
        this.projectStartDate = VersionNumberBuilder.parseDate(projectStartDate);
        this.environmentVariableName = environmentVariableName;
        try {
            this.oBuildsToday = Integer.parseInt(buildsToday);
        }
        catch (Exception e) {
            this.oBuildsToday = -1;
        }
        try {
            this.oBuildsThisMonth = Integer.parseInt(buildsThisMonth);
        }
        catch (Exception e) {
            this.oBuildsThisMonth = -1;
        }
        try {
            this.oBuildsThisYear = Integer.parseInt(buildsThisYear);
        }
        catch (Exception e) {
            this.oBuildsThisYear = -1;
        }
        try {
            this.oBuildsAllTime = Integer.parseInt(buildsAllTime);
        }
        catch (Exception e) {
            this.oBuildsAllTime = -1;
        }
    }

    public String getBuildsToday() {
        return "";
    }

    public String getBuildsThisMonth() {
        return "";
    }

    public String getBuildsThisYear() {
        return "";
    }

    public String getBuildsAllTime() {
        return "";
    }

    private static Date parseDate(String dateString) {
        try {
            return defaultDateFormat.parse(dateString);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    public String getVersionNumberString() {
        return this.versionNumberString;
    }

    public String getProjectStartDate() {
        return defaultDateFormat.format(this.projectStartDate);
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    private VersionNumberBuildInfo incBuild(Build build, PrintStream log) throws IOException {
        Run prevBuild = build.getPreviousBuild();
        int buildsToday = 1;
        int buildsThisMonth = 1;
        int buildsThisYear = 1;
        int buildsAllTime = 1;
        if (prevBuild != null) {
            Calendar curCal = build.getTimestamp();
            Calendar todayCal = prevBuild.getTimestamp();
            VersionNumberAction prevAction = (VersionNumberAction)prevBuild.getAction(VersionNumberAction.class);
            if (prevAction != null) {
                VersionNumberBuildInfo info = prevAction.getInfo();
                buildsToday = curCal.get(5) == todayCal.get(5) && curCal.get(2) == todayCal.get(2) && curCal.get(1) == todayCal.get(1) ? info.getBuildsToday() + 1 : 1;
                buildsThisMonth = curCal.get(2) == todayCal.get(2) && curCal.get(1) == todayCal.get(1) ? info.getBuildsThisMonth() + 1 : 1;
                buildsThisYear = curCal.get(1) == todayCal.get(1) ? info.getBuildsThisYear() + 1 : 1;
                buildsAllTime = info.getBuildsAllTime() + 1;
            }
        }
        boolean saveOverrides = false;
        if (this.oBuildsToday >= 0) {
            buildsToday = this.oBuildsToday;
            this.oBuildsToday = -1;
            saveOverrides = true;
        }
        if (this.oBuildsThisMonth >= 0) {
            buildsThisMonth = this.oBuildsThisMonth;
            this.oBuildsThisMonth = -1;
            saveOverrides = true;
        }
        if (this.oBuildsThisYear >= 0) {
            buildsThisYear = this.oBuildsThisYear;
            this.oBuildsThisYear = -1;
            saveOverrides = true;
        }
        if (this.oBuildsAllTime >= 0) {
            buildsAllTime = this.oBuildsAllTime;
            this.oBuildsAllTime = -1;
            saveOverrides = true;
        }
        if (saveOverrides) {
            build.getProject().save();
        }
        return new VersionNumberBuildInfo(buildsToday, buildsThisMonth, buildsThisYear, buildsAllTime);
    }

    private static String formatVersionNumber(String versionNumberFormatString, Date projectStartDate, VersionNumberBuildInfo info, Map<String, String> enVars, Calendar buildDate, PrintStream log) {
        String vnf = new String(versionNumberFormatString);
        int blockStart = 0;
        do {
            Calendar projectStartCal;
            if ((blockStart = vnf.indexOf("${")) < 0) continue;
            int blockEnd = vnf.indexOf("}", blockStart) + 1;
            if (blockEnd <= blockStart) {
                vnf = vnf.substring(0, blockStart);
                break;
            }
            int commandStart = blockStart + 2;
            int commandEnd = blockEnd - 1;
            int argumentStart = vnf.indexOf(",", blockStart);
            int argumentEnd = 0;
            if (argumentStart > 0 && argumentStart < blockEnd) {
                argumentEnd = blockEnd - 1;
                commandEnd = argumentStart;
            }
            String expressionKey = vnf.substring(commandStart, commandEnd);
            String argumentString = argumentEnd > 0 ? vnf.substring(argumentStart + 1, argumentEnd).trim() : "";
            String replaceValue = "";
            if ("".equals(expressionKey)) {
                replaceValue = "";
            } else if ("BUILD_DATE_FORMATTED".equals(expressionKey)) {
                DateFormat fmt = SimpleDateFormat.getInstance();
                if (!"".equals(argumentString)) {
                    String fmtString = argumentString.substring(argumentString.indexOf(34) + 1, argumentString.indexOf(34, argumentString.indexOf(34) + 1));
                    fmt = new SimpleDateFormat(fmtString);
                }
                replaceValue = fmt.format(buildDate.getTime());
            } else if ("BUILD_DAY".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(buildDate.get(5)), argumentString.length());
            } else if ("BUILD_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(buildDate.get(2) + 1), argumentString.length());
            } else if ("BUILD_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(buildDate.get(1)), argumentString.length());
            } else if ("BUILDS_TODAY".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(info.getBuildsToday()), argumentString.length());
            } else if ("BUILDS_THIS_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(info.getBuildsThisMonth()), argumentString.length());
            } else if ("BUILDS_THIS_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(info.getBuildsThisYear()), argumentString.length());
            } else if ("BUILDS_ALL_TIME".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(info.getBuildsAllTime()), argumentString.length());
            } else if ("MONTHS_SINCE_PROJECT_START".equals(expressionKey)) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int monthsSinceStart = buildDate.get(2) - projectStartCal.get(2);
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(monthsSinceStart += (buildDate.get(1) - projectStartCal.get(1)) * 12), argumentString.length());
            } else if ("YEARS_SINCE_PROJECT_START".equals(expressionKey)) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int yearsSinceStart = buildDate.get(1) - projectStartCal.get(1);
                replaceValue = VersionNumberBuilder.sizeTo(Integer.toString(yearsSinceStart), argumentString.length());
            } else {
                for (String enVarKey : enVars.keySet()) {
                    if (!enVarKey.equals(expressionKey)) continue;
                    replaceValue = enVars.get(enVarKey);
                }
            }
            vnf = vnf.substring(0, blockStart) + replaceValue + vnf.substring(blockEnd, vnf.length());
        } while (blockStart >= 0);
        return vnf;
    }

    private static String sizeTo(String s, int length) {
        while (s.length() < length) {
            s = "0" + s;
        }
        return s;
    }

    public BuildWrapper.Environment setUp(Build build, Launcher launcher, BuildListener listener) {
        String formattedVersionNumber = "";
        try {
            VersionNumberBuildInfo info = this.incBuild(build, listener.getLogger());
            formattedVersionNumber = VersionNumberBuilder.formatVersionNumber(this.versionNumberString, this.projectStartDate, info, (Map<String, String>)build.getEnvironment(), build.getTimestamp(), listener.getLogger());
            build.addAction((Action)new VersionNumberAction(info, formattedVersionNumber));
        }
        catch (IOException e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        catch (InterruptedException e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        catch (Exception e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        final String finalVersionNumber = formattedVersionNumber;
        return new BuildWrapper.Environment(){

            public void buildEnvVars(Map<String, String> env) {
                env.put(VersionNumberBuilder.this.environmentVariableName, finalVersionNumber);
            }
        };
    }

    public BuildWrapperDescriptor getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(VersionNumberBuilder.class);
            this.load();
        }

        public FormValidation doCheckEnvironmentVariableName(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set an environment variable name");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionNumberString(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a version number format string.  For more information, click on the ?.");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the name too short?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectStartDate(@QueryParameter String value) {
            if (value.length() > 0 && VersionNumberBuilder.parseDate(value).compareTo(new Date(0L)) == 0) {
                return FormValidation.error((String)"Valid dates are in the format yyyy-mm-dd");
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Create a formatted version number";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            return super.configure(req, json);
        }

        public boolean isApplicable(AbstractProject<?, ?> proj) {
            return true;
        }
    }
}

