/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.tools.versionnumber;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.jvnet.hudson.tools.versionnumber.VersionNumberAction;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuildInfo;
import org.jvnet.hudson.tools.versionnumber.VersionNumberBuilder;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class VersionNumberBuilder
extends BuildWrapper {
    private static final DateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private final String versionNumberString;
    private final Date projectStartDate;
    private final String environmentVariableName;
    private int oBuildsToday;
    private int oBuildsThisMonth;
    private int oBuildsThisYear;
    private int oBuildsAllTime;
    private boolean skipFailedBuilds;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VersionNumberBuilder(String versionNumberString, String projectStartDate, String environmentVariableName, String buildsToday, String buildsThisMonth, String buildsThisYear, String buildsAllTime, boolean skipFailedBuilds) {
        this.versionNumberString = versionNumberString;
        this.projectStartDate = VersionNumberBuilder.parseDate((String)projectStartDate);
        this.environmentVariableName = environmentVariableName;
        this.skipFailedBuilds = skipFailedBuilds;
        try {
            this.oBuildsToday = Integer.parseInt(buildsToday);
        }
        catch (Exception e) {
            this.oBuildsToday = -1;
        }
        try {
            this.oBuildsThisMonth = Integer.parseInt(buildsThisMonth);
        }
        catch (Exception e) {
            this.oBuildsThisMonth = -1;
        }
        try {
            this.oBuildsThisYear = Integer.parseInt(buildsThisYear);
        }
        catch (Exception e) {
            this.oBuildsThisYear = -1;
        }
        try {
            this.oBuildsAllTime = Integer.parseInt(buildsAllTime);
        }
        catch (Exception e) {
            this.oBuildsAllTime = -1;
        }
    }

    public String getBuildsToday() {
        return "";
    }

    public String getBuildsThisMonth() {
        return "";
    }

    public String getBuildsThisYear() {
        return "";
    }

    public String getBuildsAllTime() {
        return "";
    }

    public boolean getSkipFailedBuilds() {
        return this.skipFailedBuilds;
    }

    private static Date parseDate(String dateString) {
        try {
            return defaultDateFormat.parse(dateString);
        }
        catch (Exception e) {
            return new Date(0L);
        }
    }

    public String getVersionNumberString() {
        return this.versionNumberString;
    }

    public String getProjectStartDate() {
        return defaultDateFormat.format(this.projectStartDate);
    }

    public String getEnvironmentVariableName() {
        return this.environmentVariableName;
    }

    private Run getPreviousBuildWithVersionNumber(AbstractBuild build) {
        for (Run prevBuild = build.getPreviousBuild(); prevBuild != null; prevBuild = prevBuild.getPreviousBuild()) {
            VersionNumberAction prevAction = (VersionNumberAction)prevBuild.getAction(VersionNumberAction.class);
            if (prevAction == null) continue;
            return prevBuild;
        }
        return null;
    }

    private VersionNumberBuildInfo incBuild(AbstractBuild build, PrintStream log) throws IOException {
        Run prevBuild = this.getPreviousBuildWithVersionNumber(build);
        int buildsToday = 1;
        int buildsThisMonth = 1;
        int buildsThisYear = 1;
        int buildsAllTime = 1;
        int buildInc = 1;
        if (prevBuild != null) {
            if (this.skipFailedBuilds && !prevBuild.getResult().equals(Result.SUCCESS)) {
                buildInc = 0;
            }
            Calendar curCal = build.getTimestamp();
            Calendar todayCal = prevBuild.getTimestamp();
            VersionNumberAction prevAction = (VersionNumberAction)prevBuild.getAction(VersionNumberAction.class);
            VersionNumberBuildInfo info = prevAction.getInfo();
            buildsToday = curCal.get(5) == todayCal.get(5) && curCal.get(2) == todayCal.get(2) && curCal.get(1) == todayCal.get(1) ? info.getBuildsToday() + buildInc : 1;
            buildsThisMonth = curCal.get(2) == todayCal.get(2) && curCal.get(1) == todayCal.get(1) ? info.getBuildsThisMonth() + buildInc : 1;
            buildsThisYear = curCal.get(1) == todayCal.get(1) ? info.getBuildsThisYear() + buildInc : 1;
            buildsAllTime = info.getBuildsAllTime() + buildInc;
        }
        boolean saveOverrides = false;
        if (this.oBuildsToday >= 0) {
            buildsToday = this.oBuildsToday;
            this.oBuildsToday = -1;
            saveOverrides = true;
        }
        if (this.oBuildsThisMonth >= 0) {
            buildsThisMonth = this.oBuildsThisMonth;
            this.oBuildsThisMonth = -1;
            saveOverrides = true;
        }
        if (this.oBuildsThisYear >= 0) {
            buildsThisYear = this.oBuildsThisYear;
            this.oBuildsThisYear = -1;
            saveOverrides = true;
        }
        if (this.oBuildsAllTime >= 0) {
            buildsAllTime = this.oBuildsAllTime;
            this.oBuildsAllTime = -1;
            saveOverrides = true;
        }
        if (saveOverrides) {
            build.getProject().save();
        }
        return new VersionNumberBuildInfo(buildsToday, buildsThisMonth, buildsThisYear, buildsAllTime);
    }

    private static String formatVersionNumber(String versionNumberFormatString, Date projectStartDate, VersionNumberBuildInfo info, Map<String, String> enVars, Calendar buildDate, PrintStream log) {
        String vnf = new String(versionNumberFormatString);
        int blockStart = 0;
        do {
            Calendar projectStartCal;
            if ((blockStart = vnf.indexOf("${")) < 0) continue;
            int blockEnd = vnf.indexOf("}", blockStart) + 1;
            if (blockEnd <= blockStart) {
                vnf = vnf.substring(0, blockStart);
                break;
            }
            int commandStart = blockStart + 2;
            int commandEnd = blockEnd - 1;
            int argumentStart = vnf.indexOf(",", blockStart);
            int argumentEnd = 0;
            if (argumentStart > 0 && argumentStart < blockEnd) {
                argumentEnd = blockEnd - 1;
                commandEnd = argumentStart;
            }
            String expressionKey = vnf.substring(commandStart, commandEnd);
            String argumentString = argumentEnd > 0 ? vnf.substring(argumentStart + 1, argumentEnd).trim() : "";
            String replaceValue = "";
            if ("".equals(expressionKey)) {
                replaceValue = "";
            } else if ("BUILD_DATE_FORMATTED".equals(expressionKey)) {
                DateFormat fmt = SimpleDateFormat.getInstance();
                if (!"".equals(argumentString)) {
                    String fmtString = argumentString.substring(argumentString.indexOf(34) + 1, argumentString.indexOf(34, argumentString.indexOf(34) + 1));
                    fmt = new SimpleDateFormat(fmtString);
                }
                replaceValue = fmt.format(buildDate.getTime());
            } else if ("BUILD_DAY".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(buildDate.get(5)), (int)argumentString.length());
            } else if ("BUILD_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(buildDate.get(2) + 1), (int)argumentString.length());
            } else if ("BUILD_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(buildDate.get(1)), (int)argumentString.length());
            } else if ("BUILDS_TODAY".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsToday()), (int)argumentString.length());
            } else if ("BUILDS_THIS_MONTH".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsThisMonth()), (int)argumentString.length());
            } else if ("BUILDS_THIS_YEAR".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsThisYear()), (int)argumentString.length());
            } else if ("BUILDS_ALL_TIME".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsAllTime()), (int)argumentString.length());
            } else if ("BUILDS_TODAY_Z".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsToday() - 1), (int)argumentString.length());
            } else if ("BUILDS_THIS_MONTH_Z".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsThisMonth() - 1), (int)argumentString.length());
            } else if ("BUILDS_THIS_YEAR_Z".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsThisYear() - 1), (int)argumentString.length());
            } else if ("BUILDS_ALL_TIME_Z".equals(expressionKey)) {
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(info.getBuildsAllTime() - 1), (int)argumentString.length());
            } else if ("MONTHS_SINCE_PROJECT_START".equals(expressionKey)) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int monthsSinceStart = buildDate.get(2) - projectStartCal.get(2);
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(monthsSinceStart += (buildDate.get(1) - projectStartCal.get(1)) * 12), (int)argumentString.length());
            } else if ("YEARS_SINCE_PROJECT_START".equals(expressionKey)) {
                projectStartCal = Calendar.getInstance();
                projectStartCal.setTime(projectStartDate);
                int yearsSinceStart = buildDate.get(1) - projectStartCal.get(1);
                replaceValue = VersionNumberBuilder.sizeTo((String)Integer.toString(yearsSinceStart), (int)argumentString.length());
            } else {
                for (String enVarKey : enVars.keySet()) {
                    if (!enVarKey.equals(expressionKey)) continue;
                    replaceValue = enVars.get(enVarKey);
                }
            }
            vnf = vnf.substring(0, blockStart) + replaceValue + vnf.substring(blockEnd, vnf.length());
        } while (blockStart >= 0);
        return vnf;
    }

    private static String sizeTo(String s, int length) {
        while (s.length() < length) {
            s = "0" + s;
        }
        return s;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        String formattedVersionNumber = "";
        try {
            VersionNumberBuildInfo info = this.incBuild(build, listener.getLogger());
            formattedVersionNumber = VersionNumberBuilder.formatVersionNumber((String)this.versionNumberString, (Date)this.projectStartDate, (VersionNumberBuildInfo)info, (Map)build.getEnvironment((TaskListener)listener), (Calendar)build.getTimestamp(), (PrintStream)listener.getLogger());
            build.addAction((Action)new VersionNumberAction(info, formattedVersionNumber));
        }
        catch (IOException e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        catch (InterruptedException e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        catch (Exception e) {
            listener.error(e.toString());
            build.setResult(Result.FAILURE);
        }
        String finalVersionNumber = formattedVersionNumber;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BuildWrapperDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    static /* synthetic */ String access$000(VersionNumberBuilder x0) {
        return x0.environmentVariableName;
    }

    static /* synthetic */ Date access$100(String x0) {
        return VersionNumberBuilder.parseDate((String)x0);
    }
}

