//
// typica - A client library for Amazon Web Services
// Copyright (C) 2007 Xerox Corporation
// 
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package com.xerox.amazonws.ec2;

/**
 * An instance of this class represents an EC2 keypair.
 * <p/>
 * Instances are returned by calls to
 * {@link com.xerox.amazonws.ec2.Jec2#createKeyPair(String)},
 * {@link com.xerox.amazonws.ec2.Jec2#describeKeyPairs(List)}, and
 * {@link com.xerox.amazonws.ec2.Jec2#describeKeyPairs(String[])}.
 */
public class KeyPairInfo {
	private String keyName;
	private String keyFingerprint;
	private String keyMaterial;

	public KeyPairInfo(String keyName, String keyFingerprint,
			String keyMaterial) {
		this.keyName = keyName;
		this.keyFingerprint = keyFingerprint;
		this.keyMaterial = keyMaterial;
	}

	public String getKeyName() {
		return keyName;
	}

	public String getKeyFingerprint() {
		return keyFingerprint;
	}

	public String getKeyMaterial() {
		return keyMaterial;
	}

	public String toString() {
		return "KeyPair[Name=" + this.keyName + ", fingerprint="
				+ this.keyFingerprint + ", material=" + this.keyMaterial
				+ "]";
	}
}

