/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.common;

import com.xerox.amazonws.common.AWSConnection;
import com.xerox.amazonws.common.AWSError;
import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.JAXBuddy;
import com.xerox.amazonws.typica.jaxb.ErrorResponse;
import com.xerox.amazonws.typica.jaxb.Response;
import com.xerox.amazonws.typica.sqs2.jaxb.Error;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.SocketException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSQueryConnection
extends AWSConnection {
    private static final Log log = LogFactory.getLog(AWSQueryConnection.class);
    private int maxRetries = 5;
    private String userAgent = "typica/";
    private int sigVersion = 1;
    private HttpClient hc = null;
    private int maxConnections = 100;
    private String proxyHost = null;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String proxyDomain;

    public AWSQueryConnection(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        String version = "?";
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
            version = props.getProperty("version");
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.userAgent = this.userAgent + version + " (" + System.getProperty("os.arch") + "; " + System.getProperty("os.name") + ")";
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int connections) {
        this.maxConnections = connections;
        this.hc = null;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int retries) {
        this.maxRetries = retries;
    }

    public int getSignatureVersion() {
        return this.sigVersion;
    }

    public void setProxyValues(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.hc = null;
    }

    public void setProxyValues(String host, int port, String user, String password) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPassword = password;
        this.hc = null;
    }

    public void setProxyValues(String host, int port, String user, String password, String domain) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPassword = password;
        this.proxyDomain = domain;
        this.hc = null;
    }

    public void useSystemProxy() {
        this.proxyHost = System.getProperty("http.proxyHost");
        if (this.proxyHost != null && this.proxyHost.trim().equals("")) {
            this.proxyHost = null;
        }
        this.proxyPort = this.getPort();
        try {
            this.proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.proxyUser = System.getProperty("http.proxyUser");
        this.proxyPassword = System.getProperty("http.proxyPassword");
        this.proxyDomain = System.getProperty("http.proxyDomain");
        this.hc = null;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setSignatureVersion(int version) {
        if (version != 0 && version != 1) {
            throw new IllegalArgumentException("Only signature versions 0 and 1 supported");
        }
        this.sigVersion = version;
    }

    protected HttpClient getHttpClient() {
        if (this.hc == null) {
            this.configureHttpClient();
        }
        return this.hc;
    }

    public void setHttpClient(HttpClient hc) {
        this.hc = hc;
    }

    protected <T> T makeRequest(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws HttpException, IOException, JAXBException, AWSException {
        HashMap<String, String> qParams = new HashMap<String, String>(params);
        qParams.put("Action", action);
        qParams.put("AWSAccessKeyId", this.getAwsAccessKeyId());
        qParams.put("SignatureVersion", "" + this.sigVersion);
        qParams.put("Timestamp", AWSQueryConnection.httpDate());
        if (this.headers != null) {
            for (String key : this.headers.keySet()) {
                Iterator j = ((List)this.headers.get(key)).iterator();
                while (j.hasNext()) {
                    qParams.put(key, (String)j.next());
                }
            }
        }
        ArrayList keys = new ArrayList(qParams.keySet());
        Collator stringCollator = Collator.getInstance();
        stringCollator.setStrength(0);
        Collections.sort(keys, stringCollator);
        StringBuilder resource = new StringBuilder();
        if (this.sigVersion == 0) {
            resource.append((String)qParams.get("Action"));
            resource.append((String)qParams.get("Timestamp"));
        } else {
            for (String key : keys) {
                resource.append(key);
                resource.append((String)qParams.get(key));
            }
        }
        String encoded = this.urlencode(this.encode(this.getSecretAccessKey(), resource.toString(), false));
        resource = new StringBuilder();
        for (String key : keys) {
            resource.append("&");
            resource.append(key);
            resource.append("=");
            resource.append(this.urlencode((String)qParams.get(key)));
        }
        resource.setCharAt(0, '?');
        resource.append("&Signature=");
        resource.append(encoded);
        URL url = this.makeURL(resource.toString());
        method.setURI(new URI(url.toString(), true));
        method.setRequestHeader(new Header("User-Agent", this.userAgent));
        if (this.sigVersion == 0) {
            method.setRequestHeader(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        }
        T response = null;
        boolean done = false;
        int retries = 0;
        boolean doRetry = false;
        AWSException error = null;
        do {
            int responseCode = 600;
            try {
                responseCode = this.getHttpClient().executeMethod((HttpMethod)method);
            }
            catch (SocketException ex) {
                doRetry = true;
                error = new AWSException(ex.getMessage(), ex);
            }
            if (responseCode < 300) {
                if (respType != null) {
                    InputStream iStr = method.getResponseBodyAsStream();
                    response = JAXBuddy.deserializeXMLStream(respType, iStr);
                }
                done = true;
            } else {
                String body;
                if (responseCode < 400) {
                    throw new HttpException("redirect error : " + responseCode);
                }
                if (responseCode < 500) {
                    body = this.getStringFromStream(method.getResponseBodyAsStream());
                    throw this.createException(body, "Client error : ");
                }
                if (responseCode < 600) {
                    doRetry = true;
                    body = this.getStringFromStream(method.getResponseBodyAsStream());
                    error = this.createException(body, "");
                }
            }
            if (!doRetry) continue;
            if (++retries > this.maxRetries) {
                throw new HttpException("Number of retries exceeded : " + action, (Throwable)error);
            }
            doRetry = false;
            try {
                Thread.sleep((int)Math.pow(2.0, retries) * 1000);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        } while (!done);
        return response;
    }

    private void configureHttpClient() {
        MultiThreadedHttpConnectionManager connMgr = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams connParams = connMgr.getParams();
        connParams.setMaxTotalConnections(this.maxConnections);
        connParams.setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, this.maxConnections);
        connMgr.setParams(connParams);
        this.hc = new HttpClient((HttpConnectionManager)connMgr);
        if (this.proxyHost != null) {
            HostConfiguration hostConfig = new HostConfiguration();
            hostConfig.setProxy(this.proxyHost, this.proxyPort);
            this.hc.setHostConfiguration(hostConfig);
            log.info((Object)("Proxy Host set to " + this.proxyHost + ":" + this.proxyPort));
            if (this.proxyUser != null && !this.proxyUser.trim().equals("")) {
                if (this.proxyDomain != null) {
                    this.hc.getState().setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)new NTCredentials(this.proxyUser, this.proxyPassword, this.proxyHost, this.proxyDomain));
                } else {
                    this.hc.getState().setProxyCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPassword));
                }
            }
        }
    }

    private String getStringFromStream(InputStream iStr) throws IOException {
        int bytes;
        InputStreamReader rdr = new InputStreamReader(iStr, "UTF-8");
        StringWriter wtr = new StringWriter();
        char[] buf = new char[1024];
        while ((bytes = rdr.read(buf)) > -1) {
            if (bytes <= 0) continue;
            wtr.write(buf, 0, bytes);
        }
        iStr.close();
        return wtr.toString();
    }

    private AWSException createException(String errorResponse, String msgPrefix) throws JAXBException {
        String requestId;
        String errorMsg;
        Object resp;
        ArrayList<AWSError> errors = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(errorResponse.getBytes());
        if (errorResponse.indexOf("<ErrorResponse") > -1) {
            try {
                resp = JAXBuddy.deserializeXMLStream(com.xerox.amazonws.typica.sqs2.jaxb.ErrorResponse.class, bais);
                List<Error> errs = ((com.xerox.amazonws.typica.sqs2.jaxb.ErrorResponse)resp).getErrors();
                errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                requestId = ((com.xerox.amazonws.typica.sqs2.jaxb.ErrorResponse)resp).getRequestID();
                errors = new ArrayList<AWSError>();
                for (Error e : errs) {
                    errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                }
            }
            catch (UnmarshalException ex) {
                bais = new ByteArrayInputStream(errorResponse.getBytes());
                ErrorResponse resp2 = JAXBuddy.deserializeXMLStream(ErrorResponse.class, bais);
                List<com.xerox.amazonws.typica.jaxb.Error> errs = resp2.getErrors();
                errorMsg = "(" + errs.get(0).getCode() + ") " + errs.get(0).getMessage();
                requestId = resp2.getRequestID();
                errors = new ArrayList();
                for (com.xerox.amazonws.typica.jaxb.Error e : errs) {
                    errors.add(new AWSError(AWSError.ErrorType.getTypeFromString(e.getType()), e.getCode(), e.getMessage()));
                }
            }
        } else {
            resp = JAXBuddy.deserializeXMLStream(Response.class, bais);
            errorMsg = ((Response)resp).getErrors().getError().getMessage();
            requestId = ((Response)resp).getRequestID();
        }
        AWSException ex = new AWSException(msgPrefix + errorMsg, requestId);
        ex.setErrors(errors);
        return ex;
    }

    private static String httpDate() {
        String DateFormat2 = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(new Date());
    }
}

