/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.ec2;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.ec2.AddressInfo;
import com.xerox.amazonws.ec2.AttachmentInfo;
import com.xerox.amazonws.ec2.AvailabilityZone;
import com.xerox.amazonws.ec2.BlockDeviceMapping;
import com.xerox.amazonws.ec2.ConsoleOutput;
import com.xerox.amazonws.ec2.DescribeImageAttributeResult;
import com.xerox.amazonws.ec2.EC2Exception;
import com.xerox.amazonws.ec2.GroupDescription;
import com.xerox.amazonws.ec2.ImageAttribute;
import com.xerox.amazonws.ec2.ImageDescription;
import com.xerox.amazonws.ec2.ImageListAttribute;
import com.xerox.amazonws.ec2.ImageListAttributeItem;
import com.xerox.amazonws.ec2.ImageType;
import com.xerox.amazonws.ec2.InstanceType;
import com.xerox.amazonws.ec2.KeyPairInfo;
import com.xerox.amazonws.ec2.LaunchConfiguration;
import com.xerox.amazonws.ec2.LaunchPermissionAttribute;
import com.xerox.amazonws.ec2.ProductCodesAttribute;
import com.xerox.amazonws.ec2.ProductInstanceInfo;
import com.xerox.amazonws.ec2.ReservationDescription;
import com.xerox.amazonws.ec2.SnapshotInfo;
import com.xerox.amazonws.ec2.TerminatingInstanceDescription;
import com.xerox.amazonws.ec2.VolumeInfo;
import com.xerox.amazonws.typica.jaxb.AllocateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AssociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.AttachVolumeResponse;
import com.xerox.amazonws.typica.jaxb.AttachmentSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.AttachmentSetResponseType;
import com.xerox.amazonws.typica.jaxb.AuthorizeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneItemType;
import com.xerox.amazonws.typica.jaxb.AvailabilityZoneSetType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingItemType;
import com.xerox.amazonws.typica.jaxb.BlockDeviceMappingType;
import com.xerox.amazonws.typica.jaxb.ConfirmProductInstanceResponse;
import com.xerox.amazonws.typica.jaxb.CreateKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.CreateSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.CreateSnapshotResponse;
import com.xerox.amazonws.typica.jaxb.CreateVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DeleteKeyPairResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSecurityGroupResponse;
import com.xerox.amazonws.typica.jaxb.DeleteSnapshotResponse;
import com.xerox.amazonws.typica.jaxb.DeleteVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DeregisterImageResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeAddressesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeAvailabilityZonesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeImagesResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeInstancesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseInfoType;
import com.xerox.amazonws.typica.jaxb.DescribeKeyPairsResponseItemType;
import com.xerox.amazonws.typica.jaxb.DescribeSecurityGroupsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsResponse;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeSnapshotsSetResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesResponse;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesSetItemResponseType;
import com.xerox.amazonws.typica.jaxb.DescribeVolumesSetResponseType;
import com.xerox.amazonws.typica.jaxb.DetachVolumeResponse;
import com.xerox.amazonws.typica.jaxb.DisassociateAddressResponse;
import com.xerox.amazonws.typica.jaxb.GetConsoleOutputResponse;
import com.xerox.amazonws.typica.jaxb.GroupItemType;
import com.xerox.amazonws.typica.jaxb.GroupSetType;
import com.xerox.amazonws.typica.jaxb.IpPermissionSetType;
import com.xerox.amazonws.typica.jaxb.IpPermissionType;
import com.xerox.amazonws.typica.jaxb.IpRangeItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionItemType;
import com.xerox.amazonws.typica.jaxb.LaunchPermissionListType;
import com.xerox.amazonws.typica.jaxb.ModifyImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.NullableAttributeValueType;
import com.xerox.amazonws.typica.jaxb.ProductCodeItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodeListType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetItemType;
import com.xerox.amazonws.typica.jaxb.ProductCodesSetType;
import com.xerox.amazonws.typica.jaxb.RebootInstancesResponse;
import com.xerox.amazonws.typica.jaxb.RegisterImageResponse;
import com.xerox.amazonws.typica.jaxb.ReleaseAddressResponse;
import com.xerox.amazonws.typica.jaxb.ReservationSetType;
import com.xerox.amazonws.typica.jaxb.ResetImageAttributeResponse;
import com.xerox.amazonws.typica.jaxb.RevokeSecurityGroupIngressResponse;
import com.xerox.amazonws.typica.jaxb.RunInstancesResponse;
import com.xerox.amazonws.typica.jaxb.RunningInstancesItemType;
import com.xerox.amazonws.typica.jaxb.RunningInstancesSetType;
import com.xerox.amazonws.typica.jaxb.SecurityGroupItemType;
import com.xerox.amazonws.typica.jaxb.SecurityGroupSetType;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponse;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponseInfoType;
import com.xerox.amazonws.typica.jaxb.TerminateInstancesResponseItemType;
import com.xerox.amazonws.typica.jaxb.UserIdGroupPairType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jec2
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Jec2.class);

    public Jec2(String awsAccessId, String awsSecretKey) {
        this(awsAccessId, awsSecretKey, true);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure) {
        this(awsAccessId, awsSecretKey, isSecure, "ec2.amazonaws.com");
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server) {
        this(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
    }

    public Jec2(String awsAccessId, String awsSecretKey, boolean isSecure, String server, int port) {
        super(awsAccessId, awsSecretKey, isSecure, server, port);
        ArrayList<String> vals = new ArrayList<String>();
        vals.add("2008-05-05");
        this.headers.put("Version", vals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerImage(String imageLocation) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageLocation", imageLocation);
        GetMethod method = new GetMethod();
        try {
            RegisterImageResponse response = this.makeRequestInt((HttpMethodBase)method, "RegisterImage", params, RegisterImageResponse.class);
            String string = response.getImageId();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterImage(String imageId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        GetMethod method = new GetMethod();
        try {
            DeregisterImageResponse response = this.makeRequestInt((HttpMethodBase)method, "DeregisterImage", params, DeregisterImageResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not deregister image : " + imageId + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<ImageDescription> describeImages(String[] imageIds) throws EC2Exception {
        return this.describeImages(Arrays.asList(imageIds));
    }

    public List<ImageDescription> describeImages(List<String> imageIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < imageIds.size(); ++i) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByOwner(List<String> owners) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < owners.size(); ++i) {
            params.put("Owner." + (i + 1), owners.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByExecutability(List<String> users) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < users.size(); ++i) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
        }
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImagesByImageType(ImageType type) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageType", type.getTypeId());
        return this.describeImages(params);
    }

    public List<ImageDescription> describeImages(List<String> imageIds, List<String> owners, List<String> users, ImageType type) throws EC2Exception {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        for (i = 0; i < imageIds.size(); ++i) {
            params.put("ImageId." + (i + 1), imageIds.get(i));
        }
        for (i = 0; i < owners.size(); ++i) {
            params.put("Owner." + (i + 1), owners.get(i));
        }
        for (i = 0; i < users.size(); ++i) {
            params.put("ExecutableBy." + (i + 1), users.get(i));
        }
        if (type != null) {
            params.put("ImageType", type.getTypeId());
        }
        return this.describeImages(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ImageDescription> describeImages(Map<String, String> params) throws EC2Exception {
        GetMethod method = new GetMethod();
        try {
            DescribeImagesResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeImages", params, DescribeImagesResponse.class);
            ArrayList<ImageDescription> result = new ArrayList<ImageDescription>();
            DescribeImagesResponseInfoType set = response.getImagesSet();
            for (DescribeImagesResponseItemType item : set.getItems()) {
                ArrayList<String> codes = new ArrayList<String>();
                ProductCodesSetType code_set = item.getProductCodes();
                if (code_set != null) {
                    for (ProductCodesSetItemType code : code_set.getItems()) {
                        codes.add(code.getProductCode());
                    }
                }
                result.add(new ImageDescription(item.getImageId(), item.getImageLocation(), item.getImageOwnerId(), item.getImageState(), item.isIsPublic(), codes));
            }
            ArrayList<ImageDescription> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, InstanceType.DEFAULT);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, true, type);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type) throws EC2Exception {
        return this.runInstances(imageId, minCount, maxCount, groupSet, userData, keyName, publicAddr, type, null, null, null, null);
    }

    public ReservationDescription runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String userData, String keyName, boolean publicAddr, InstanceType type, String availabilityZone, String kernelId, String ramdiskId, List<BlockDeviceMapping> blockDeviceMappings) throws EC2Exception {
        LaunchConfiguration lc = new LaunchConfiguration(imageId);
        lc.setMinCount(minCount);
        lc.setMaxCount(maxCount);
        lc.setSecurityGroup(groupSet);
        if (userData != null) {
            lc.setUserData(userData.getBytes());
        }
        lc.setKeyName(keyName);
        lc.setInstanceType(type);
        lc.setAvailabilityZone(availabilityZone);
        lc.setKernelId(kernelId);
        lc.setRamdiskId(ramdiskId);
        lc.setBlockDevicemappings(blockDeviceMappings);
        return this.runInstances(lc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReservationDescription runInstances(LaunchConfiguration lc) throws EC2Exception {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", lc.getImageId());
        params.put("MinCount", "" + lc.getMinCount());
        params.put("MaxCount", "" + lc.getMaxCount());
        byte[] userData = lc.getUserData();
        if (userData != null && userData.length > 0) {
            params.put("UserData", new String(Base64.encodeBase64((byte[])userData)));
        }
        params.put("AddressingType", "public");
        String keyName = lc.getKeyName();
        if (keyName != null && !keyName.trim().equals("")) {
            params.put("KeyName", keyName);
        }
        if (lc.getSecurityGroup() != null) {
            for (i = 0; i < lc.getSecurityGroup().size(); ++i) {
                params.put("SecurityGroup." + (i + 1), lc.getSecurityGroup().get(i));
            }
        }
        params.put("InstanceType", lc.getInstanceType().getTypeId());
        if (lc.getAvailabilityZone() != null && !lc.getAvailabilityZone().trim().equals("")) {
            params.put("Placement.AvailabilityZone", lc.getAvailabilityZone());
        }
        if (lc.getKernelId() != null && !lc.getKernelId().trim().equals("")) {
            params.put("KernelId", lc.getKernelId());
        }
        if (lc.getRamdiskId() != null && !lc.getRamdiskId().trim().equals("")) {
            params.put("RamdiskId", lc.getRamdiskId());
        }
        if (lc.getBlockDevicemappings() != null) {
            for (i = 0; i < lc.getBlockDevicemappings().size(); ++i) {
                BlockDeviceMapping bdm = lc.getBlockDevicemappings().get(i);
                params.put("BlockDeviceMapping." + (i + 1) + ".VirtualName", bdm.getVirtualName());
                params.put("BlockDeviceMapping." + (i + 1) + ".DeviceName", bdm.getDeviceName());
            }
        }
        GetMethod method = new GetMethod();
        try {
            RunInstancesResponse response = this.makeRequestInt((HttpMethodBase)method, "RunInstances", params, RunInstancesResponse.class);
            ReservationDescription res = new ReservationDescription(response.getOwnerId(), response.getReservationId());
            GroupSetType grp_set = response.getGroupSet();
            for (GroupItemType rsp_item : grp_set.getItems()) {
                res.addGroup(rsp_item.getGroupId());
            }
            RunningInstancesSetType set = response.getInstancesSet();
            for (RunningInstancesItemType rsp_item : set.getItems()) {
                res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getPrivateDnsName(), rsp_item.getDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getLaunchTime().toGregorianCalendar(), InstanceType.getTypeFromString(rsp_item.getInstanceType()), rsp_item.getPlacement().getAvailabilityZone(), rsp_item.getKernelId(), rsp_item.getRamdiskId());
            }
            ReservationDescription reservationDescription = res;
            return reservationDescription;
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<TerminatingInstanceDescription> terminateInstances(String[] instanceIds) throws EC2Exception {
        return this.terminateInstances(Arrays.asList(instanceIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TerminatingInstanceDescription> terminateInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            TerminateInstancesResponse response = this.makeRequestInt((HttpMethodBase)method, "TerminateInstances", params, TerminateInstancesResponse.class);
            response.getInstancesSet();
            ArrayList<TerminatingInstanceDescription> res = new ArrayList<TerminatingInstanceDescription>();
            TerminateInstancesResponseInfoType set = response.getInstancesSet();
            for (TerminateInstancesResponseItemType rsp_item : set.getItems()) {
                res.add(new TerminatingInstanceDescription(rsp_item.getInstanceId(), rsp_item.getPreviousState().getName(), rsp_item.getPreviousState().getCode(), rsp_item.getShutdownState().getName(), rsp_item.getShutdownState().getCode()));
            }
            ArrayList<TerminatingInstanceDescription> arrayList = res;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<ReservationDescription> describeInstances(String[] instanceIds) throws EC2Exception {
        return this.describeInstances(Arrays.asList(instanceIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReservationDescription> describeInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            DescribeInstancesResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeInstances", params, DescribeInstancesResponse.class);
            ArrayList<ReservationDescription> result = new ArrayList<ReservationDescription>();
            ReservationSetType res_set = response.getReservationSet();
            for (RunInstancesResponse item : res_set.getItems()) {
                ReservationDescription res = new ReservationDescription(item.getOwnerId(), item.getReservationId());
                GroupSetType grp_set = item.getGroupSet();
                for (GroupItemType rsp_item : grp_set.getItems()) {
                    res.addGroup(rsp_item.getGroupId());
                }
                RunningInstancesSetType set = item.getInstancesSet();
                for (RunningInstancesItemType rsp_item : set.getItems()) {
                    res.addInstance(rsp_item.getImageId(), rsp_item.getInstanceId(), rsp_item.getPrivateDnsName(), rsp_item.getDnsName(), rsp_item.getInstanceState(), rsp_item.getReason(), rsp_item.getKeyName(), rsp_item.getLaunchTime().toGregorianCalendar(), InstanceType.getTypeFromString(rsp_item.getInstanceType()), rsp_item.getPlacement().getAvailabilityZone(), rsp_item.getKernelId(), rsp_item.getRamdiskId());
                }
                result.add(res);
            }
            ArrayList<ReservationDescription> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    public void rebootInstances(String[] instanceIds) throws EC2Exception {
        this.rebootInstances(Arrays.asList(instanceIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebootInstances(List<String> instanceIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < instanceIds.size(); ++i) {
            params.put("InstanceId." + (i + 1), instanceIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            RebootInstancesResponse response = this.makeRequestInt((HttpMethodBase)method, "RebootInstances", params, RebootInstancesResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not reboot instances. No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsoleOutput getConsoleOutput(String instanceId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        GetMethod method = new GetMethod();
        try {
            GetConsoleOutputResponse response = this.makeRequestInt((HttpMethodBase)method, "GetConsoleOutput", params, GetConsoleOutputResponse.class);
            ConsoleOutput consoleOutput = new ConsoleOutput(response.getInstanceId(), response.getTimestamp().toGregorianCalendar(), new String(Base64.decodeBase64((byte[])response.getOutput().getBytes())));
            return consoleOutput;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSecurityGroup(String name, String desc) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        params.put("GroupDescription", desc);
        GetMethod method = new GetMethod();
        try {
            CreateSecurityGroupResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateSecurityGroup", params, CreateSecurityGroupResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not create security group : " + name + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSecurityGroup(String name) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", name);
        GetMethod method = new GetMethod();
        try {
            DeleteSecurityGroupResponse response = this.makeRequestInt((HttpMethodBase)method, "DeleteSecurityGroup", params, DeleteSecurityGroupResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not delete security group : " + name + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<GroupDescription> describeSecurityGroups(String[] groupNames) throws EC2Exception {
        return this.describeSecurityGroups(Arrays.asList(groupNames));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GroupDescription> describeSecurityGroups(List<String> groupNames) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < groupNames.size(); ++i) {
            params.put("GroupName." + (i + 1), groupNames.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            DescribeSecurityGroupsResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeSecurityGroups", params, DescribeSecurityGroupsResponse.class);
            ArrayList<GroupDescription> result = new ArrayList<GroupDescription>();
            SecurityGroupSetType rsp_set = response.getSecurityGroupInfo();
            for (SecurityGroupItemType item : rsp_set.getItems()) {
                GroupDescription group = new GroupDescription(item.getGroupName(), item.getGroupDescription(), item.getOwnerId());
                IpPermissionSetType perms = item.getIpPermissions();
                for (IpPermissionType perm : perms.getItems()) {
                    GroupDescription.IpPermission group_perms = group.addPermission(perm.getIpProtocol(), perm.getFromPort(), perm.getToPort());
                    for (UserIdGroupPairType uid_group : perm.getGroups().getItems()) {
                        group_perms.addUserGroupPair(uid_group.getUserId(), uid_group.getGroupName());
                    }
                    for (IpRangeItemType range : perm.getIpRanges().getItems()) {
                        group_perms.addIpRange(range.getCidrIp());
                    }
                }
                result.add(group);
            }
            ArrayList<GroupDescription> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authorizeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        GetMethod method = new GetMethod();
        try {
            AuthorizeSecurityGroupIngressResponse response = this.makeRequestInt((HttpMethodBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authorizeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        GetMethod method = new GetMethod();
        try {
            AuthorizeSecurityGroupIngressResponse response = this.makeRequestInt((HttpMethodBase)method, "AuthorizeSecurityGroupIngress", params, AuthorizeSecurityGroupIngressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not authorize security ingress : " + groupName + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeSecurityGroupIngress(String groupName, String secGroupName, String secGroupOwnerId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("SourceSecurityGroupOwnerId", secGroupOwnerId);
        params.put("SourceSecurityGroupName", secGroupName);
        GetMethod method = new GetMethod();
        try {
            RevokeSecurityGroupIngressResponse response = this.makeRequestInt((HttpMethodBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeSecurityGroupIngress(String groupName, String ipProtocol, int fromPort, int toPort, String cidrIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("GroupName", groupName);
        params.put("IpProtocol", ipProtocol);
        params.put("FromPort", "" + fromPort);
        params.put("ToPort", "" + toPort);
        params.put("CidrIp", cidrIp);
        GetMethod method = new GetMethod();
        try {
            RevokeSecurityGroupIngressResponse response = this.makeRequestInt((HttpMethodBase)method, "RevokeSecurityGroupIngress", params, RevokeSecurityGroupIngressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not revoke security ingress : " + groupName + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPairInfo createKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        GetMethod method = new GetMethod();
        try {
            CreateKeyPairResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateKeyPair", params, CreateKeyPairResponse.class);
            KeyPairInfo keyPairInfo = new KeyPairInfo(response.getKeyName(), response.getKeyFingerprint(), response.getKeyMaterial());
            return keyPairInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<KeyPairInfo> describeKeyPairs(String[] keyIds) throws EC2Exception {
        return this.describeKeyPairs(Arrays.asList(keyIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<KeyPairInfo> describeKeyPairs(List<String> keyIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < keyIds.size(); ++i) {
            params.put("KeyName." + (i + 1), keyIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            DescribeKeyPairsResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeKeyPairs", params, DescribeKeyPairsResponse.class);
            ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>();
            DescribeKeyPairsResponseInfoType set = response.getKeySet();
            for (DescribeKeyPairsResponseItemType item : set.getItems()) {
                result.add(new KeyPairInfo(item.getKeyName(), item.getKeyFingerprint(), null));
            }
            ArrayList<KeyPairInfo> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKeyPair(String keyName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("KeyName", keyName);
        GetMethod method = new GetMethod();
        try {
            DeleteKeyPairResponse response = this.makeRequestInt((HttpMethodBase)method, "DeleteKeyPair", params, DeleteKeyPairResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not delete keypair : " + keyName + ". No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyImageAttribute(String imageId, ImageListAttribute attribute, ImageListAttributeOperationType operationType) throws EC2Exception {
        HashMap<String, String> params;
        block17: {
            block16: {
                params = new HashMap<String, String>();
                params.put("ImageId", imageId);
                if (!attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) break block16;
                params.put("Attribute", "launchPermission");
                switch (operationType) {
                    case add: {
                        params.put("OperationType", "add");
                        break block17;
                    }
                    case remove: {
                        params.put("OperationType", "remove");
                        break block17;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown attribute operation.");
                    }
                }
            }
            if (attribute.getType().equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
                params.put("Attribute", "productCodes");
            }
        }
        int gNum = 1;
        int iNum = 1;
        int pNum = 1;
        block12: for (ImageListAttributeItem item : attribute.getImageListAttributeItems()) {
            switch (item.getType()) {
                case group: {
                    params.put("UserGroup." + gNum, item.getValue());
                    ++gNum;
                    continue block12;
                }
                case userId: {
                    params.put("UserId." + iNum, item.getValue());
                    ++iNum;
                    continue block12;
                }
                case productCode: {
                    params.put("ProductCode." + pNum, item.getValue());
                    ++pNum;
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Unknown item type.");
        }
        GetMethod method = new GetMethod();
        try {
            ModifyImageAttributeResponse response = this.makeRequestInt((HttpMethodBase)method, "ModifyImageAttribute", params, ModifyImageAttributeResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not reset image attribute. No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            throw new IllegalArgumentException("Cannot reset productCodes attribute");
        }
        GetMethod method = new GetMethod();
        try {
            ResetImageAttributeResponse response = this.makeRequestInt((HttpMethodBase)method, "ResetImageAttribute", params, ResetImageAttributeResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not reset image attribute. No reason given.");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DescribeImageAttributeResult describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ImageId", imageId);
        if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.launchPermission)) {
            params.put("Attribute", "launchPermission");
        } else if (imageAttribute.equals((Object)ImageAttribute.ImageAttributeType.productCodes)) {
            params.put("Attribute", "productCodes");
        }
        GetMethod method = new GetMethod();
        try {
            NullableAttributeValueType val;
            Object item;
            ListIterator<Object> i;
            Object list;
            DescribeImageAttributeResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeImageAttribute", params, DescribeImageAttributeResponse.class);
            ImageListAttribute attribute = null;
            if (response.getLaunchPermission() != null) {
                list = response.getLaunchPermission();
                attribute = new LaunchPermissionAttribute();
                i = ((LaunchPermissionListType)list).getItems().listIterator();
                while (i.hasNext()) {
                    item = (LaunchPermissionItemType)i.next();
                    if (((LaunchPermissionItemType)item).getGroup() != null) {
                        attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.group, ((LaunchPermissionItemType)item).getGroup());
                        continue;
                    }
                    if (((LaunchPermissionItemType)item).getUserId() == null) continue;
                    attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.userId, ((LaunchPermissionItemType)item).getUserId());
                }
            } else if (response.getProductCodes() != null) {
                list = response.getProductCodes();
                attribute = new ProductCodesAttribute();
                i = ((ProductCodeListType)list).getItems().listIterator();
                while (i.hasNext()) {
                    item = (ProductCodeItemType)i.next();
                    if (((ProductCodeItemType)item).getProductCode() == null) continue;
                    attribute.addImageListAttributeItem(ImageListAttribute.ImageListAttributeItemType.productCode, ((ProductCodeItemType)item).getProductCode());
                }
            }
            ArrayList<String> codes = new ArrayList<String>();
            ProductCodeListType set = response.getProductCodes();
            if (set != null) {
                for (ProductCodeItemType code : set.getItems()) {
                    codes.add(code.getProductCode());
                }
            }
            String kernel = (val = response.getKernel()) != null ? val.getValue() : "";
            val = response.getRamdisk();
            String ramdisk = val != null ? val.getValue() : "";
            ArrayList<BlockDeviceMapping> bdm = new ArrayList<BlockDeviceMapping>();
            BlockDeviceMappingType bdmSet = response.getBlockDeviceMapping();
            if (bdmSet != null) {
                for (BlockDeviceMappingItemType mapping : bdmSet.getItems()) {
                    bdm.add(new BlockDeviceMapping(mapping.getVirtualName(), mapping.getDeviceName()));
                }
            }
            DescribeImageAttributeResult describeImageAttributeResult = new DescribeImageAttributeResult(response.getImageId(), attribute, codes, kernel, ramdisk, bdm);
            return describeImageAttributeResult;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProductInstanceInfo confirmProductInstance(String instanceId, String productCode) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("ProductCode", productCode);
        GetMethod method = new GetMethod();
        try {
            ConfirmProductInstanceResponse response = this.makeRequestInt((HttpMethodBase)method, "ConfirmProductInstance", params, ConfirmProductInstanceResponse.class);
            if (response.isReturn()) {
                ProductInstanceInfo productInstanceInfo = new ProductInstanceInfo(instanceId, productCode, response.getOwnerId());
                return productInstanceInfo;
            }
            ProductInstanceInfo productInstanceInfo = null;
            return productInstanceInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AvailabilityZone> describeAvailabilityZones(List<String> zones) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (zones != null && zones.size() > 0) {
            for (int i = 0; i < zones.size(); ++i) {
                params.put("ZoneName." + (i + 1), zones.get(i));
            }
        }
        GetMethod method = new GetMethod();
        try {
            DescribeAvailabilityZonesResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeAvailabilityZones", params, DescribeAvailabilityZonesResponse.class);
            ArrayList<AvailabilityZone> ret = new ArrayList<AvailabilityZone>();
            AvailabilityZoneSetType set = response.getAvailabilityZoneInfo();
            for (AvailabilityZoneItemType item : set.getItems()) {
                ret.add(new AvailabilityZone(item.getZoneName(), item.getZoneState()));
            }
            ArrayList<AvailabilityZone> arrayList = ret;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AddressInfo> describeAddresses(List<String> addresses) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (addresses != null && addresses.size() > 0) {
            for (int i = 0; i < addresses.size(); ++i) {
                params.put("PublicIp." + (i + 1), addresses.get(i));
            }
        }
        GetMethod method = new GetMethod();
        try {
            DescribeAddressesResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeAddresses", params, DescribeAddressesResponse.class);
            ArrayList<AddressInfo> ret = new ArrayList<AddressInfo>();
            DescribeAddressesResponseInfoType set = response.getAddressesSet();
            for (DescribeAddressesResponseItemType item : set.getItems()) {
                ret.add(new AddressInfo(item.getPublicIp(), item.getInstanceId()));
            }
            ArrayList<AddressInfo> arrayList = ret;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String allocateAddress() throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        GetMethod method = new GetMethod();
        try {
            AllocateAddressResponse response = this.makeRequestInt((HttpMethodBase)method, "AllocateAddress", params, AllocateAddressResponse.class);
            String string = response.getPublicIp();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateAddress(String instanceId, String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("InstanceId", instanceId);
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            AssociateAddressResponse response = this.makeRequestInt((HttpMethodBase)method, "AssociateAddress", params, AssociateAddressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not associate address with instance (no reason given).");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disassociateAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            DisassociateAddressResponse response = this.makeRequestInt((HttpMethodBase)method, "DisassociateAddress", params, DisassociateAddressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not disassociate address with instance (no reason given).");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAddress(String publicIp) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("PublicIp", publicIp);
        GetMethod method = new GetMethod();
        try {
            ReleaseAddressResponse response = this.makeRequestInt((HttpMethodBase)method, "ReleaseAddress", params, ReleaseAddressResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not release address (no reason given).");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumeInfo createVolume(String size, String snapshotId, String zoneName) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (size != null && !size.equals("")) {
            params.put("Size", size);
        }
        params.put("SnapshotId", snapshotId == null ? "" : snapshotId);
        params.put("AvailabilityZone", zoneName);
        GetMethod method = new GetMethod();
        try {
            CreateVolumeResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateVolume", params, CreateVolumeResponse.class);
            VolumeInfo volumeInfo = new VolumeInfo(response.getVolumeId(), response.getSize(), response.getSnapshotId(), response.getAvailabilityZone(), response.getStatus(), response.getCreateTime().toGregorianCalendar());
            return volumeInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVolume(String volumeId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        GetMethod method = new GetMethod();
        try {
            DeleteVolumeResponse response = this.makeRequestInt((HttpMethodBase)method, "DeleteVolume", params, DeleteVolumeResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not release delete volume (no reason given).");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<VolumeInfo> describeVolumes(String[] volumeIds) throws EC2Exception {
        return this.describeVolumes(Arrays.asList(volumeIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VolumeInfo> describeVolumes(List<String> volumeIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < volumeIds.size(); ++i) {
            params.put("VolumeId." + (i + 1), volumeIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            DescribeVolumesResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeVolumes", params, DescribeVolumesResponse.class);
            ArrayList<VolumeInfo> result = new ArrayList<VolumeInfo>();
            DescribeVolumesSetResponseType res_set = response.getVolumeSet();
            for (DescribeVolumesSetItemResponseType item : res_set.getItems()) {
                VolumeInfo vol = new VolumeInfo(item.getVolumeId(), item.getSize(), item.getSnapshotId(), item.getAvailabilityZone(), item.getStatus(), item.getCreateTime().toGregorianCalendar());
                AttachmentSetResponseType set = item.getAttachmentSet();
                for (AttachmentSetItemResponseType as_item : set.getItems()) {
                    vol.addAttachmentInfo(as_item.getVolumeId(), as_item.getInstanceId(), as_item.getDevice(), as_item.getStatus(), as_item.getAttachTime().toGregorianCalendar());
                }
                result.add(vol);
            }
            ArrayList<VolumeInfo> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentInfo attachVolume(String volumeId, String instanceId, String device) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        params.put("InstanceId", instanceId);
        params.put("Device", device);
        GetMethod method = new GetMethod();
        try {
            AttachVolumeResponse response = this.makeRequestInt((HttpMethodBase)method, "AttachVolume", params, AttachVolumeResponse.class);
            AttachmentInfo attachmentInfo = new AttachmentInfo(response.getVolumeId(), response.getInstanceId(), response.getDevice(), response.getStatus(), response.getAttachTime().toGregorianCalendar());
            return attachmentInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttachmentInfo detachVolume(String volumeId, String instanceId, String device, boolean force) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        params.put("InstanceId", instanceId == null ? "" : instanceId);
        params.put("Device", device == null ? "" : device);
        params.put("Force", force ? "true" : "false");
        GetMethod method = new GetMethod();
        try {
            DetachVolumeResponse response = this.makeRequestInt((HttpMethodBase)method, "DetachVolume", params, DetachVolumeResponse.class);
            AttachmentInfo attachmentInfo = new AttachmentInfo(response.getVolumeId(), response.getInstanceId(), response.getDevice(), response.getStatus(), response.getAttachTime().toGregorianCalendar());
            return attachmentInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotInfo createSnapshot(String volumeId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VolumeId", volumeId);
        GetMethod method = new GetMethod();
        try {
            CreateSnapshotResponse response = this.makeRequestInt((HttpMethodBase)method, "CreateSnapshot", params, CreateSnapshotResponse.class);
            SnapshotInfo snapshotInfo = new SnapshotInfo(response.getSnapshotId(), response.getVolumeId(), response.getStatus(), response.getStartTime().toGregorianCalendar(), response.getProgress());
            return snapshotInfo;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSnapshot(String snapshotId) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("SnapshotId", snapshotId);
        GetMethod method = new GetMethod();
        try {
            DeleteSnapshotResponse response = this.makeRequestInt((HttpMethodBase)method, "DeleteSnapshot", params, DeleteSnapshotResponse.class);
            if (!response.isReturn()) {
                throw new EC2Exception("Could not release delete snapshot (no reason given).");
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    public List<SnapshotInfo> describeSnapshots(String[] snapshotIds) throws EC2Exception {
        return this.describeSnapshots(Arrays.asList(snapshotIds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SnapshotInfo> describeSnapshots(List<String> snapshotIds) throws EC2Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < snapshotIds.size(); ++i) {
            params.put("SnapshotId." + (i + 1), snapshotIds.get(i));
        }
        GetMethod method = new GetMethod();
        try {
            DescribeSnapshotsResponse response = this.makeRequestInt((HttpMethodBase)method, "DescribeSnapshots", params, DescribeSnapshotsResponse.class);
            ArrayList<SnapshotInfo> result = new ArrayList<SnapshotInfo>();
            DescribeSnapshotsSetResponseType res_set = response.getSnapshotSet();
            for (DescribeSnapshotsSetItemResponseType item : res_set.getItems()) {
                SnapshotInfo vol = new SnapshotInfo(item.getSnapshotId(), item.getVolumeId(), item.getStatus(), item.getStartTime().toGregorianCalendar(), item.getProgress());
                result.add(vol);
            }
            ArrayList<SnapshotInfo> arrayList = result;
            return arrayList;
        }
        finally {
            method.releaseConnection();
        }
    }

    protected <T> T makeRequestInt(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws EC2Exception {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new EC2Exception(ex);
        }
        catch (JAXBException ex) {
            throw new EC2Exception("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new EC2Exception(ex.getMessage(), ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageListAttributeOperationType {
        add,
        remove;

    }
}

