/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.amazonws.sdb;

import com.xerox.amazonws.common.AWSException;
import com.xerox.amazonws.common.AWSQueryConnection;
import com.xerox.amazonws.sdb.AttrWorker;
import com.xerox.amazonws.sdb.Counter;
import com.xerox.amazonws.sdb.Item;
import com.xerox.amazonws.sdb.ItemAttribute;
import com.xerox.amazonws.sdb.ItemListener;
import com.xerox.amazonws.sdb.QueryResult;
import com.xerox.amazonws.sdb.QueryWithAttributesResult;
import com.xerox.amazonws.sdb.SDBException;
import com.xerox.amazonws.sdb.SimpleDB;
import com.xerox.amazonws.typica.sdb.jaxb.Attribute;
import com.xerox.amazonws.typica.sdb.jaxb.QueryResponse;
import com.xerox.amazonws.typica.sdb.jaxb.QueryResult;
import com.xerox.amazonws.typica.sdb.jaxb.QueryWithAttributesResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain
extends AWSQueryConnection {
    private static Log logger = LogFactory.getLog(Domain.class);
    private String domainName;
    private int maxThreads = 30;
    private ThreadPoolExecutor executor;

    protected Domain(String domainName, String awsAccessId, String awsSecretKey, boolean isSecure, String server) throws SDBException {
        super(awsAccessId, awsSecretKey, isSecure, server, isSecure ? 443 : 80);
        this.domainName = domainName;
        SimpleDB.setVersionHeader(this);
    }

    public String getName() {
        return this.domainName;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int threads) {
        this.maxThreads = threads;
    }

    public Item getItem(String identifier) throws SDBException {
        Item ret = new Item(identifier, this.domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer());
        ret.setSignatureVersion(this.getSignatureVersion());
        ret.setHttpClient(this.getHttpClient());
        return ret;
    }

    public QueryResult listItems() throws SDBException {
        return this.listItems(null);
    }

    public QueryResult listItems(String queryString) throws SDBException {
        return this.listItems(queryString, null);
    }

    public QueryResult listItems(String queryString, String nextToken) throws SDBException {
        return this.listItems(queryString, nextToken, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult listItems(String queryString, String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        params.put("QueryExpression", queryString == null ? "" : queryString);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfItems", "" + maxResults);
        }
        GetMethod method = new GetMethod();
        try {
            QueryResponse response = this.makeRequestInt((HttpMethodBase)method, "Query", params, QueryResponse.class);
            QueryResult queryResult = new QueryResult(response.getQueryResult().getNextToken(), Item.createList(response.getQueryResult().getItemNames().toArray(new QueryResult.ItemName[0]), this.domainName, this.getAwsAccessKeyId(), this.getSecretAccessKey(), this.isSecure(), this.getServer(), this.getSignatureVersion(), this.getHttpClient()));
            return queryResult;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<ItemAttribute>> getItemsAttributes(List<String> items) throws SDBException {
        Hashtable<String, List<ItemAttribute>> results = new Hashtable<String, List<ItemAttribute>>();
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        Counter running = new Counter(0);
        for (String item : items) {
            while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            Counter counter = running;
            synchronized (counter) {
                running.increment();
            }
            pool.execute(new AttrWorker(this.getItem(item), running, results, null));
            Thread.yield();
        }
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getItemsAttributes(List<String> items, ItemListener listener) throws SDBException {
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        Counter running = new Counter(0);
        for (String item : items) {
            while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            Counter counter = running;
            synchronized (counter) {
                running.increment();
            }
            pool.execute(new AttrWorker(this.getItem(item), running, null, listener));
            Thread.yield();
        }
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listItemsAttributes(String queryString, ItemListener listener) throws SDBException {
        ThreadPoolExecutor pool = this.getThreadPoolExecutor();
        pool.setRejectedExecutionHandler(new RejectionHandler());
        String nextToken = "";
        Counter running = new Counter(0);
        do {
            try {
                QueryResult result = this.listItems(queryString, nextToken, 250);
                List<Item> items = result.getItemList();
                for (Item i : items) {
                    while (pool.getActiveCount() == pool.getMaximumPoolSize()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {}
                    }
                    Counter counter = running;
                    synchronized (counter) {
                        running.increment();
                    }
                    pool.execute(new AttrWorker(i, running, null, listener));
                    Thread.yield();
                }
                nextToken = result.getNextToken();
            }
            catch (SDBException ex) {
                System.out.println("Query '" + queryString + "' Failure: ");
                ex.printStackTrace();
            }
        } while (nextToken != null && nextToken.trim().length() > 0);
        while (running.getValue() != 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {}
        }
        if (this.executor == null) {
            pool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryWithAttributesResult listItemsWithAttributes(String queryString, List<String> attributes, String nextToken, int maxResults) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        params.put("QueryExpression", queryString == null ? "" : queryString);
        if (nextToken != null) {
            params.put("NextToken", nextToken);
        }
        if (maxResults > 0) {
            params.put("MaxNumberOfItems", "" + maxResults);
        }
        GetMethod method = new GetMethod();
        try {
            QueryWithAttributesResponse response = this.makeRequestInt((HttpMethodBase)method, "QueryWithAttributes", params, QueryWithAttributesResponse.class);
            Hashtable<String, List<ItemAttribute>> results = new Hashtable<String, List<ItemAttribute>>();
            for (com.xerox.amazonws.typica.sdb.jaxb.Item i : response.getQueryWithAttributesResult().getItems()) {
                ArrayList<ItemAttribute> attrs = new ArrayList<ItemAttribute>();
                for (Attribute a : i.getAttributes()) {
                    attrs.add(this.createAttribute(a));
                }
                String iName = i.getName().getValue();
                String encoding = i.getName().getEncoding();
                if (encoding != null && encoding.equals("base64")) {
                    iName = new String(Base64.decodeBase64((byte[])iName.getBytes()));
                }
                results.put(iName, attrs);
            }
            QueryWithAttributesResult queryWithAttributesResult = new QueryWithAttributesResult(response.getQueryWithAttributesResult().getNextToken(), results);
            return queryWithAttributesResult;
        }
        finally {
            method.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listItemsWithAttributes(String queryString, List<String> attributes, ItemListener listener) throws SDBException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DomainName", this.domainName);
        int idx = 1;
        if (attributes != null) {
            for (String attr : attributes) {
                params.put("AttributeName." + idx, attr);
                ++idx;
            }
        }
        params.put("QueryExpression", queryString == null ? "" : queryString);
        GetMethod method = new GetMethod();
        try {
            String nextToken = null;
            do {
                QueryWithAttributesResponse response = this.makeRequestInt((HttpMethodBase)method, "QueryWithAttributes", params, QueryWithAttributesResponse.class);
                for (com.xerox.amazonws.typica.sdb.jaxb.Item i : response.getQueryWithAttributesResult().getItems()) {
                    ArrayList<ItemAttribute> attrs = new ArrayList<ItemAttribute>();
                    for (Attribute a : i.getAttributes()) {
                        attrs.add(this.createAttribute(a));
                    }
                    if (listener == null) continue;
                    String iName = i.getName().getValue();
                    String encoding = i.getName().getEncoding();
                    if (encoding != null && encoding.equals("base64")) {
                        iName = new String(Base64.decodeBase64((byte[])iName.getBytes()));
                    }
                    listener.itemAvailable(iName, attrs);
                }
                nextToken = response.getQueryWithAttributesResult().getNextToken();
                params.remove("NextToken");
                params.put("NextToken", nextToken);
            } while (nextToken != null && !nextToken.equals(""));
        }
        finally {
            method.releaseConnection();
        }
    }

    public void deleteItem(String identifier) throws SDBException {
        this.getItem(identifier).deleteAttributes(null);
    }

    static List<Domain> createList(String[] domainNames, String awsAccessKeyId, String awsSecretAccessKey, boolean isSecure, String server, int signatureVersion, HttpClient hc) throws SDBException {
        ArrayList<Domain> ret = new ArrayList<Domain>();
        for (int i = 0; i < domainNames.length; ++i) {
            Domain dom = new Domain(domainNames[i], awsAccessKeyId, awsSecretAccessKey, isSecure, server);
            dom.setSignatureVersion(signatureVersion);
            dom.setHttpClient(hc);
            ret.add(dom);
        }
        return ret;
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return new ThreadPoolExecutor(this.maxThreads, this.maxThreads, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxThreads));
    }

    public void setThreadPoolExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    protected <T> T makeRequestInt(HttpMethodBase method, String action, Map<String, String> params, Class<T> respType) throws SDBException {
        try {
            return this.makeRequest(method, action, params, respType);
        }
        catch (AWSException ex) {
            throw new SDBException(ex);
        }
        catch (JAXBException ex) {
            throw new SDBException("Problem parsing returned message.", (Exception)((Object)ex));
        }
        catch (HttpException ex) {
            throw new SDBException(ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new SDBException(ex.getMessage(), ex);
        }
    }

    private ItemAttribute createAttribute(Attribute a) {
        String name = a.getName().getValue();
        String encoding = a.getName().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            name = new String(Base64.decodeBase64((byte[])name.getBytes()));
        }
        String value = a.getValue().getValue();
        encoding = a.getValue().getEncoding();
        if (encoding != null && encoding.equals("base64")) {
            value = new String(Base64.decodeBase64((byte[])value.getBytes()));
        }
        return new ItemAttribute(name, value, false);
    }

    protected class RejectionHandler
    implements RejectedExecutionHandler {
        protected RejectionHandler() {
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            r.run();
        }
    }
}

